!macro GetDlgItemRect OUT_LEFT OUT_TOP OUT_RIGHT OUT_BOTTOM HWNDDLG CTLID
    Push ${CTLID}
    Push ${HWNDDLG}
    Exch $R0
    Exch
    Exch $R1
    Push $R2
    GetDlgItem $R1 $R0 $R1
    System::Call /NOUNLOAD "*(i,i,t,i,i,i,i,i,i,i,i)i.s"
    Pop $R2
    System::Call /NOUNLOAD 'user32::GetWindowRect(i,i)i(R1,R2)'
    System::Call /NOUNLOAD 'user32::ScreenToClient(i,i)i(R0,R2)'
    IntOp $R1 $R2 + 8
    System::Call /NOUNLOAD 'user32::ScreenToClient(i,i)i(R0,R1)'
    Exch 2
    Pop $R0
    Pop $R1
    System::Call /NOUNLOAD "*$R2(i.s,i.s,i.s,i.s)"
    System::Free $R2
    Exch 4
    Pop $R2
    Pop ${OUT_TOP}
    Pop ${OUT_RIGHT}
    Pop ${OUT_BOTTOM}
    Pop ${OUT_LEFT}
!macroend

!include "MUI2.nsh"

Name "About Button Example"
OutFile AboutButton.exe
InstallDir $TEMP

RequestExecutionLevel User

!define IDC_ABOUT 1300

!define MUI_CUSTOMFUNCTION_GUIINIT onGUIInit

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_LANGUAGE "English"

Section Install

SectionEnd

Function onGUIInit

    System::Alloc 56
    Pop $0
    System::Call "*$0(i56)"
    System::Call "user32::GetWindowInfo(i$HWNDPARENT,ir0)"
    IntOp $R0 $0 + 20
    System::Call "*$R0(i.R1,i.R2,i.R3,i.R4)"
    System::Free $0
    IntOp $R1 $R3 - $R1
    !insertmacro GetDlgItemRect $R0 $R2 $R3 $R4 $HWNDPARENT 2
    IntOp $R1 $R1 - $R3
    IntOp $R3 $R3 - $R0
    IntOp $R4 $R4 - $R2
    System::Call 'kernel32::GetModuleHandle(i0)i.r0'
    System::Call 'user32::CreateWindowEx(i0,t"Button",t"About",i${BS_PUSHBUTTON}|${WS_CHILD}|${WS_VISIBLE}|${WS_TABSTOP},iR1,iR2,iR3,iR4,i$HWNDPARENT,i${IDC_ABOUT},ir0,i0)i.R0'
    System::Call 'kernel32::FreeLibrary(ir0)'
    CreateFont $0 '$(^Font)' '$(^FontSize)'
    SendMessage $R0 ${WM_SETFONT} $0 0
    GetFunctionAddress $0 FuncAbout
    ButtonEvent::AddEventHandler /NoUnload ${IDC_ABOUT} $0

FunctionEnd

Function FuncAbout

    ;0x40=MB_OK(0x0)|MB_ICONINFORMATION(0x40)
    System::Call 'user32::MessageBox(i$HWNDPARENT,t"This is the About Button Example!",t"About",i0x40)'

FunctionEnd

Function .onGUIEnd

    ButtonEvent::Unload

FunctionEnd