unit ListDriver;

interface

uses
  classes,types,controls,inifiles,sysutils;




  type
  TDriverDef = class(TCollectionItem)
  private
         FSPDRP_FRIENDLYNAME,
         FSPDRP_DEVICEDESC,
         FSPDRP_HARDWAREID,
         FSPDRP_COMPATIBLEIDS,
         FSPDRP_MFG,
         FSPDRP_DRIVER:ansistring;

         FDriverDesc,
         FProviderName,
         FDriverVersion,
         FMatchingDeviceId,
         FInfPath,
         FInfSection,
         FInfSectionExt:ansistring;
         Fstatus,Fproblem:DWORD;
         FDriverDate:tdate;

  published

     //     SetupDiGetDeviceRegistryPropertyA   SETUPAPI.dll
    property SPDRP_FRIENDLYNAME : ansistring      read  FSPDRP_FRIENDLYNAME
                                        write FSPDRP_FRIENDLYNAME;
    property SPDRP_DEVICEDESC : ansistring        read  FSPDRP_DEVICEDESC
                                        write FSPDRP_DEVICEDESC;
    property SPDRP_HARDWAREID : ansistring        read  FSPDRP_HARDWAREID
                                        write FSPDRP_HARDWAREID;
    property SPDRP_COMPATIBLEIDS : ansistring     read  FSPDRP_COMPATIBLEIDS
                                        write FSPDRP_COMPATIBLEIDS;
    property SPDRP_MFG : ansistring               read  FSPDRP_MFG
                                        write FSPDRP_MFG;
    property SPDRP_DRIVER : ansistring            read  FSPDRP_DRIVER
                                        write FSPDRP_DRIVER;

      //      RegQueryValueEx
      property DriverDesc : ansistring            read  FDriverDesc
                                        write FDriverDesc;
      property ProviderName: ansistring           read  FProviderName
                                        write FProviderName;
      property DriverDate: Tdate             read  FDriverDate
                                        write FDriverDate;
      property DriverVersion: ansistring          read  FDriverVersion
                                        write FDriverVersion;
      property MatchingDeviceId: ansistring       read  FMatchingDeviceId
                                        write FMatchingDeviceId;
      property InfPath: ansistring                read  FInfPath
                                        write FInfPath;
      property InfSection: ansistring             read  FInfSection
                                        write FInfSection;
      property InfSectionExt: ansistring          read  FInfSectionExt
                                        write FInfSectionExt;
      property Status: DWORD                 read  Fstatus
                                        write Fstatus;
      property Problem: DWORD                read  Fproblem
                                        write Fproblem;
  end;


    TDriverList = class(TCollection)
  protected
    function GetItem(Index: Integer): TDriverDef;
  public
    function Add: TDriverDef;
    property Items[Index: Integer]: TDriverDef read GetItem;

    procedure SaveTofile(Filename:string);
    procedure Loadfromfile(Filename:string);
  end;



implementation

function TDriverList.Add: TDriverDef;
begin
   Result := (inherited Add) as TDriverDef;
end;
 
function TDriverList.GetItem(Index: Integer): TDriverDef;
begin
  Result := (inherited GetItem(Index)) as TDriverDef;
end;


procedure TDriverList.SaveTofile(Filename:string);
var i:integer;
INIsave:Tinifile;
begin
INIsave:=TIniFile.Create(Filename);

  for i:=0 to Count-1 do
    begin
    INIsave.WriteString(inttostr(i),'SPDRP_FRIENDLYNAME',self.Items[i].SPDRP_FRIENDLYNAME);
    INIsave.WriteString(inttostr(i),'SPDRP_DEVICEDESC',self.Items[i].SPDRP_DEVICEDESC);
    INIsave.WriteString(inttostr(i),'SPDRP_HARDWAREID',self.Items[i].SPDRP_HARDWAREID);
    INIsave.WriteString(inttostr(i),'SPDRP_COMPATIBLEIDS',self.Items[i].SPDRP_COMPATIBLEIDS);
    INIsave.WriteString(inttostr(i),'SPDRP_MFG',self.Items[i].SPDRP_MFG);
    INIsave.WriteString(inttostr(i),'SPDRP_DRIVER',self.Items[i].SPDRP_DRIVER);
    INIsave.WriteString(inttostr(i),'DriverDesc',self.Items[i].DriverDesc);
    INIsave.WriteString(inttostr(i),'ProviderName',self.Items[i].ProviderName);
    INIsave.Writefloat(inttostr(i),'DriverDate', self.Items[i].DriverDate);



    INIsave.WriteString(inttostr(i),'DriverVersion',self.Items[i].DriverVersion);
    INIsave.WriteString(inttostr(i),'MatchingDeviceId',self.Items[i].MatchingDeviceId);
    INIsave.WriteString(inttostr(i),'InfPath',self.Items[i].InfPath);
    INIsave.WriteString(inttostr(i),'InfSection',self.Items[i].InfSection);
    INIsave.WriteString(inttostr(i),'InfSectionExt',self.Items[i].InfSectionExt);
    INIsave.Writeinteger(inttostr(i),'Status',self.Items[i].Status);
    INIsave.Writeinteger(inttostr(i),'Problem',self.Items[i].Problem);
    end;
end;

procedure TDriverList.Loadfromfile(Filename:string);
var i:integer;
INIload:Tinifile;
sections:Tstringlist;
NewDef:TDriverDef;
begin
self.Clear;
INIload:=TIniFile.Create(Filename);

sections:=Tstringlist.Create;
INIload.ReadSections(sections);
//showmessage(sections.GetText);

  for i:=0 to sections.Count-1 do
    begin
    newdef:=self.Add();
    newdef.SPDRP_FRIENDLYNAME:=INIload.readstring(inttostr(i),'SPDRP_FRIENDLYNAME','');
    newdef.SPDRP_DEVICEDESC:=INIload.readstring(inttostr(i),'SPDRP_DEVICEDESC','');
    newdef.SPDRP_HARDWAREID:=INIload.readstring(inttostr(i),'SPDRP_HARDWAREID','');
    newdef.SPDRP_COMPATIBLEIDS:=INIload.readstring(inttostr(i),'SPDRP_COMPATIBLEIDS','');
    newdef.SPDRP_MFG:=INIload.readstring(inttostr(i),'SPDRP_MFG','');
    newdef.SPDRP_DRIVER:=INIload.readstring(inttostr(i),'SPDRP_DRIVER','');
    newdef.DriverDesc:=INIload.readstring(inttostr(i),'DriverDesc','');
    newdef.ProviderName:=INIload.readstring(inttostr(i),'ProviderName','');
    newdef.DriverDate:=INIload.ReadFloat(inttostr(i),'DriverDate',0);

    newdef.DriverVersion:=INIload.readstring(inttostr(i),'DriverVersion','');
    newdef.MatchingDeviceId:=INIload.readstring(inttostr(i),'MatchingDeviceId','');
    newdef.InfPath:=INIload.readstring(inttostr(i),'InfPath','');
    newdef.InfSection:=INIload.readstring(inttostr(i),'InfSection','');
    newdef.InfSectionExt:=INIload.readstring(inttostr(i),'InfSectionExt','');
    newdef.Status:=INIload.ReadInteger(inttostr(i),'Status',0);
    newdef.Problem:=INIload.ReadInteger(inttostr(i),'Problem',0);

    end;
end;



end.