#include-once
#include <FontConstants.au3>
#include <WinAPI.au3>

Global Const $HORZRES = 8
Global Const $VERTRES = 10

; int cbSize; LPCTSTR lpszDocName; LPCTSTR lpszOutput; LPCTSTR lpszDatatype; DWORD fwType;
Global Const $tagDOCINFO = "int Size;ptr DocName;ptr Output;ptr Datatype;dword Type"

Global $PageWidth, $PageHeight
Global $PixelsPerInchY, $TwipsPerPixelY, $PixelsPerInchX, $TwipsPerPixelX

Func _GetDefaultPrinter()
    Local $a_iCall = DllCall("winspool.drv", "int", "GetDefaultPrinterW", "wstr", "", "dword*", 0)
    If @error Or $a_iCall[0] Then Return SetError(1, 0, "")
    Local $iBufferSize = $a_iCall[2]

    $a_iCall = DllCall("winspool.drv", "int", "GetDefaultPrinterW", "wstr", "", "dword*", $iBufferSize)
    If @error Or Not $a_iCall[0] Then Return SetError(1, 0, "")
    Return SetError(0, 0, $a_iCall[1])
EndFunc

Func _WinAPI_CreateDC($sDriver, $sDevice)
	Local $aResult = DllCall("GDI32.dll", "hwnd", "CreateDC", "str", $sDriver, "str", $sDevice, "long", 0, "long", 0)
	Return $aResult[0]
EndFunc

Func _WinAPI_StartDoc($hDC, $tDocInfo)
	Local $aResult = DllCall("GDI32.dll", "long", "StartDoc", "hwnd", $hDC, "ptr", DllStructGetPtr($tDocInfo))
	Return $aResult[0]
EndFunc

Func _WinAPI_EndDoc($hDC)
	Local $aResult = DllCall("GDI32.dll", "long", "EndDoc", "hwnd", $hDC)
	Return $aResult[0]
EndFunc

Func _WinAPI_StartPage($hDC)
	Local $aResult = DllCall("GDI32.dll", "long", "StartPage", "hwnd", $hDC)
	Return $aResult[0]
EndFunc

Func _WinAPI_EndPage($hDC)
	Local $aResult = DllCall("GDI32.dll", "long", "EndPage", "hwnd", $hDC)
	Return $aResult[0]
EndFunc

Func _WinAPI_TextOut2($hDC, $iXStart, $iYStart, $sString)
	Local $aResult = DllCall("GDI32.dll", "long", "TextOut", "hwnd", $hDC, "long", $iXStart, "long", $iYStart, "str", $sString, "long", StringLen($sString))
	Return $aResult[0]
EndFunc

Func _TextOut_Centered_Row($hDC, $iRow, $sString, $iColor = -1) ; Y - rows
	If $iColor <> -1 Then _WinAPI_SetTextColor($hDC, $iColor)
	$OutSize = _WinAPI_GetTextExtentPoint32($hDC, $sString)
	$xLeft = (($PageWidth / 2) - (DllStructGetData($OutSize,"X") / 2)) ; Compute the starting point for the text-output operation (centered)
	$yTop = DllStructGetData($OutSize,"Y") * $iRow ; Compute the starting point for the text-output N lines down
	Return _WinAPI_TextOut2($hDC, $xLeft, $yTop, $sString)
EndFunc

Func _TextOut_Centered($hDC, $yTop, $sString, $iColor = -1) ; Y - pixels
	If $iColor <> -1 Then _WinAPI_SetTextColor($hDC, $iColor)
	$OutSize = _WinAPI_GetTextExtentPoint32($hDC, $sString)
	$xLeft = (($PageWidth / 2) - (DllStructGetData($OutSize,"X") / 2)) ; Compute the starting point for the text-output operation (centered)
	Return _WinAPI_TextOut2($hDC, $xLeft, $yTop, $sString)
EndFunc

Func _CreateFont_Simple($szFace, $nSize, $fnWeight = 400)
	Return _WinAPI_CreateFont((($nSize * -20) / $TwipsPerPixelY), 0, 0, 0, $fnWeight, False, False, False, _
		$DEFAULT_CHARSET, $OUT_DEFAULT_PRECIS, $CLIP_DEFAULT_PRECIS, $DEFAULT_QUALITY, $DEFAULT_PITCH, $szFace)
EndFunc

Func _InitPrinter($hDC, $s_DocName = "")
	$PixelsPerInchY = _WinAPI_GetDeviceCaps($hDC, $__WINAPCONSTANT_LOGPIXELSY) ; Get Pixels Per Inch Y
	$TwipsPerPixelY = 1440 / $PixelsPerInchY
	$PixelsPerInchX = _WinAPI_GetDeviceCaps($hDC, $__WINAPCONSTANT_LOGPIXELSX) ; Get Pixels Per Inch X
	$TwipsPerPixelX = 1440 / $PixelsPerInchX

	$PageWidth = _WinAPI_GetDeviceCaps($hDC, $HORZRES) ; Get width, in millimeters, of the physical screen
	$PageHeight = _WinAPI_GetDeviceCaps($hDC, $VERTRES) ; Get height, in millimeters, of the physical screen.

	$tDOCINFO = DllStructCreate($tagDOCINFO) ; Structure for Print Document info
	DllStructSetData($tDOCINFO, "Size", 20) ; Size of DOCINFO structure

	If $s_DocName <> "" Then
		$tDocName = DllStructCreate("char DocName[" & StringLen($s_DocName & chr(0)) & "]")
		DllStructSetData($tDocName, "DocName", $s_DocName & chr(0)) ; Size of DOCINFO structure
		DllStructSetData($tDOCINFO, "DocName", DllStructGetPtr($tDocName)) ; Set name of print job (Optional)
	EndIf

	_WinAPI_StartDoc($hDC, $tDOCINFO)
	_WinAPI_StartPage($hDC)
EndFunc

Func _DeInitPrinter($hDC)
	_WinAPI_EndPage($hDC)
	_WinAPI_EndDoc($hDC)
	_WinAPI_DeleteDC($hDC)
EndFunc
