//Part of AssTools (c)2007-2008 Sergey V. Bulba <vorobey@mail.khstu.ru>

program AssSave;

{$APPTYPE CONSOLE}

uses Windows,SysUtils,AssLib;

procedure ExitUsage;
begin
Writeln('  Usage:');
Writeln(' AssSave ProgramPath [filename[.CMD|.REG|.INF]]');
Writeln('  or');
Writeln(' AssSave PartOfProgramPath [filename[.CMD|.REG|.INF]]');
Writeln;
Writeln('Default result is CMD-file.');
Halt(1);
end;

procedure ExitEr(n:integer);
const
 Errs:array[2..3] of string =
  ('Error calling RegQueryInfoKey(HKEY_CLASSES_ROOT,...',
   'No associations found');
begin
Writeln('Error: ',Errs[n]);
Halt(n);
end;

procedure SetFileExt(var FN:string;const FE:string);
begin
if UpperCase(ExtractFileExt(FN)) = UpperCase(FE) then
 FN := FN + FE
else
 FN := ChangeFileExt(FN,FE);
end;


type
 TOutTp = (TCMD,TREG,TINF);
var
 InFile,OutFile,Ext:string;
 OutTp:TOutTp;
 kn:integer;
 lkname:longword;
 FTypes:TAssFTypes;
 Ass:TAssAsses;
 ftn,asn:integer;
 Keys:TAssArrayOfString;

{$IFDEF WINDOWS}{$R AssSave.rc}{$ENDIF}

begin
Writeln('Associations Saver v0.1');
Writeln('Supported saving to CMD, REG and INF files');
Writeln('(c)2007-2008 S.V.Bulba E-Mail: vorobey@mail.khstu.ru');
Writeln('Support page: http://forum.oszone.net/');
Writeln;
if not (ParamCount in [1..2]) then ExitUsage;
OutTp := TCMD; InFile := ParamStr(1);
case ParamCount of
1:
 begin
  OutFile := ExtractFileName(InFile);
  SetFileExt(OutFile,'.CMD');
 end;
2:
 begin
  OutFile := ParamStr(2);
  Ext := UpperCase(ExtractFileExt(OutFile));
  if Ext = '.REG' then
   OutTp := TREG
  else if Ext = '.INF' then
   OutTp := TINF
  else if Ext <> '.CMD' then SetFileExt(OutFile,'.CMD');
 end
else
 ExitUsage;
end;

if RegQueryInfoKey(HKEY_CLASSES_ROOT,nil,nil,nil,@kn,@lkname,nil,nil,nil,nil,nil,nil) <> ERROR_SUCCESS then ExitEr(2);
GetKeys(Keys,kn,lkname);
ftn := GetFTypes(AnsiUpperCase(InFile),FTypes,Keys); if ftn = 0 then ExitEr(3);
asn := GetAsses(Ass,FTypes,ftn,Keys);
case OutTp of
TCMD: SaveCMD(OutFile,Ass,asn,FTypes,ftn,True,True,True);
TREG: SaveREG(OutFile,Ass,asn,FTypes,ftn);
TINF: SaveINF(OutFile,Ass,asn,FTypes,ftn,True,True);
end; 
end.
