--[[
-- win7boot_02.lua
--     Windows 7 boot logo demostration 2.
--
-- by Y.Volta ( y.volta@gmail.com )
-- http://bbs.znpc.net ( lang = chs )
-- 12:00 2009/5/20
--
--]]

-- color
green = Color.new(0, 255, 0);
black = Color.new(0, 0, 0);
white = Color.new(255, 255, 255);

-- load font
chsfnt = Font.load ("16x16_yh.fnt");

-- here, the win7\win7-bootsp2.jpg is 225x4080, so we
-- will use a 640x480 to show you the effect.

img_infin = Image.load ("win7/bootsp2.jpg");
w = 225;
h = 34;

-- screen resolution
screen_w = screen:width();
screen_h = screen:height();

-- postion to show picture
x = (screen_w - w) / 2;
y = (screen_h - h) * 2 / 3;

fnt_x = x + 25;
fnt_y = y + h + 10;

n = 0;

while true do

  System:idle();
  System.sleep(20);
  
  -- reset the screen.
	screen:clear();

  -- draw the prompt string.
  screen:fontPrint (chsfnt, fnt_x, fnt_y, L("Loading Windows..."), white);
  
  -- draw the infinity
	screen:blit(x, y, img_infin, 0, n*h, w, h, false);
	
	-- update the new sub-image
	n = n + 1;	
	if n >= 120 then
    n = 0;
  end
  
  -- show them.
	screen.waitVblankStart()
	screen.flip()

end

-------------------------------------------- end of script -----
