;SetCompress off

!define PRODUCT_NAME "The KMPlayer"
!define PRODUCT_VERSION "2.9.4.1437"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define BRANDING "  "
!define pkgdir "d:\package"

!define Publisher ""
!define Contact ""
!define HelpLink "http://www.kmplayer.com/forums/index.php/"
!define URLInfoAbout "http://www.kmplayer.com/forums/index.php/"
!define URLUpdateInfo "http://www.kmplayer.com/forums/index.php/"
!define Comments ""
;###################################################################################
!include "MUI2.nsh"
!include "FileFunc.nsh"
!include "LogicLib.nsh"
!include "WordFunc.nsh"
!include "nsDialogs.nsh"

!insertmacro GetOptions
!insertmacro RefreshShellIcons
;###################################################################################
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
!define MUI_COMPONENTSPAGE_NODESC 
!define MUI_FINISHPAGE_LINK "  !"
!define MUI_FINISHPAGE_LINK_LOCATION "http://www.winreview.ru"

!define MUI_CUSTOMFUNCTION_GUIINIT onGUIInit


!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_COMPONENTS
Page custom nsDialogsPage nsDialogsPageLeave
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
; NEED FOR CODE REFRESH!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_LANGUAGE "Russian"

;###################################################################################
;ui variables
Var IconFile
Var IconFileName
Var WindowCaption
;unnatend mode variables
Var IniFile
Var gMode

;open command for files related with $installdir
Var OpenCommand
Var SysDrive

;extensions related variables
Var ClassName
Var IconIndex

;custom pages variables
Var Dialog
Var BtnBrowseIconDll
Var FileRequestIconDll
Var BtnBrowseSkin
Var FileRequestSkin

;###################################################################################
;Common directives
InstType ""
InstType ""

BrandingText "${BRANDING}"
Name "${PRODUCT_NAME}"
Caption "$WindowCaption"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
ShowInstDetails show
ShowUninstDetails show

!macro ProcessSection secID
	;
	;if gMode=1 - generate default config. if 0 and not silent - reads the config
	StrCpy $R0 1
	StrCmp $gMode 1 WriteMode
	IfSilent 0 EndMarco
		IfFileExists $IniFile 0 EndMarco
		ReadINIStr $R0 $IniFile Sections ${secID}
		IfErrors 0 +2
		StrCpy $R0 0
		Goto EndMarco
	WriteMode:
		StrCpy $R0 0
		WriteINIStr $IniFile Sections ${secID} 1
	EndMarco:	
!macroend

	
!macro RegisterExtension extenstion gforce
	StrCmp ${gforce} 0 0 +3
	!insertmacro ProcessSection ${extenstion}
	StrCmp $R0 0 EndMacro 0

	;create a class for extesion
	StrCpy $ClassName "The KMPlayer.${extenstion}"
/*  StrCmp ${extenstion} "AUDIOCD" 0 noaudio
	WriteRegStr HKCR "${extenstion}" "" "$ClassName"
	DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\${extenstion}\UserChoice"
	WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\${extenstion}\UserChoice" "Progid" "$ClassName"
  noaudio:*/  
	WriteRegStr HKCR ".${extenstion}" "" "$ClassName"
	DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.${extenstion}\UserChoice"
	WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.${extenstion}\UserChoice" "Progid" "$ClassName"
	WriteRegStr HKCR "$ClassName\shell\open" "" "  KMPlayer"
	WriteRegStr HKCR "$ClassName\shell\open\command" "" "$OpenCommand"
	
	;define  icon for class
	${Switch} ${extenstion}	

	; video
		${Case} "ASF"
			StrCpy $IconIndex 0
			${Break} 	
	
		${Case} "AVI"
			StrCpy $IconIndex 2
			${Break} 

		${Case} "WMV"
			StrCpy $IconIndex 17
			${Break} 

		${Case} "FLV"
			StrCpy $IconIndex 111
			${Break} 

		${Case} "MKV"
			StrCpy $IconIndex 30
			${Break} 

		${Case} "MOV"
			StrCpy $IconIndex 8
			${Break} 

		${Case} "3GP"
			StrCpy $IconIndex 48
			${Break} 
	
		${Case} "DIVX"
			StrCpy $IconIndex 56
			${Break} 

		${Case} "MP4"
			StrCpy $IconIndex 43
			${Break} 

		${Case} "MPG"
			StrCpy $IconIndex 12
			${Break} 
	
		${Case} "MPEG"
			StrCpy $IconIndex 11
			${Break} 
	
		${Case} "MPE"
			StrCpy $IconIndex 10
			${Break} 

		${Case} "DAT"
			StrCpy $IconIndex 3
			${Break} 
	
		${Case} "VOB"
			StrCpy $IconIndex 14
			${Break} 
	
		${Case} "IFO"
			StrCpy $IconIndex 40
			${Break} 

		${Case} "M1V"
			StrCpy $IconIndex 4
			${Break} 
	
		${Case} "M2V"
			StrCpy $IconIndex 5
			${Break} 

		${Case} "M4V"
			StrCpy $IconIndex 70
			${Break} 
	
		${Case} "MMS"
			StrCpy $IconIndex 14
			${Break} 
	
		${Case} "OGM"
			StrCpy $IconIndex 29
			${Break} 

		${Case} "QT"
			StrCpy $IconIndex 13
			${Break} 
	
		${Case} "TS"
			StrCpy $IconIndex 99
			${Break} 

		${Case} "VP6"
			StrCpy $IconIndex 101
			${Break} 
	
		${Case} "XVID"
			StrCpy $IconIndex 109
			${Break} 
	
		${Case} "3G2"
			StrCpy $IconIndex 47
			${Break} 
	
		${Case} "TP"
			StrCpy $IconIndex 97
			${Break} 

		${Case} "AVI-Neo"
			StrCpy $IconIndex 39
			${Break} 

		${Case} "BIK"
			StrCpy $IconIndex 52
			${Break} 
	
		${Case} "D2V"
			StrCpy $IconIndex 55
			${Break} 
	
		${Case} "DRC"
			StrCpy $IconIndex 57
			${Break} 
	
		${Case} "IFV"
			StrCpy $IconIndex 66
			${Break} 

		${Case} "MP2V"
			StrCpy $IconIndex 78
			${Break} 

		${Case} "MPV2"
			StrCpy $IconIndex 81
			${Break} 
	
		${Case} "MQV"
			StrCpy $IconIndex 82
			${Break} 
	
		${Case} "PART"
			StrCpy $IconIndex 86
			${Break} 
	
		${Case} "PSS"
			StrCpy $IconIndex 87
			${Break} 

		${Case} "ROQ"
			StrCpy $IconIndex 90
			${Break} 

		${Case} "SMK"
			StrCpy $IconIndex 94
			${Break} 
	
		${Case} "TPR"
			StrCpy $IconIndex 98
			${Break} 
	
		${Case} "TRP"
			StrCpy $IconIndex 110
			${Break} 
	
		${Case} "DVR-MS"
			StrCpy $IconIndex 114
			${Break} 

		${Case} "GVI"
			StrCpy $IconIndex 115
			${Break} 
	
		${Case} "NSV"
			StrCpy $IconIndex 117
			${Break} 
	
		${Case} "PMP"
			StrCpy $IconIndex 118
			${Break} 
	
		${Case} "VP7"
			StrCpy $IconIndex 120
			${Break} 

		${Case} "VC1"
			StrCpy $IconIndex 138
			${Break} 
	
		${Case} "264"
			StrCpy $IconIndex 127
			${Break} 
	
		${Case} "H264"
			StrCpy $IconIndex 131
			${Break} 
;....................................................................................	
	; audio   
		${Case} "MP3"
			StrCpy $IconIndex 9
			${Break} 	
	
		${Case} "AAC"
			StrCpy $IconIndex 42
			${Break} 
	
		${Case} "WMA"
			StrCpy $IconIndex 16
			${Break} 

		${Case} "CDA"
			StrCpy $IconIndex 54
			${Break} 	
	
		${Case} "FLAC"
			StrCpy $IconIndex 41
			${Break} 

		${Case} "M4A"
			StrCpy $IconIndex 69
			${Break} 	
	
		${Case} "MID"
			StrCpy $IconIndex 6
			${Break} 

		${Case} "MKA"
			StrCpy $IconIndex 72
			${Break} 	
	
		${Case} "MP2"
			StrCpy $IconIndex 77
			${Break} 

		${Case} "MPA"
			StrCpy $IconIndex 79
			${Break} 	

		${Case} "MPC"
			StrCpy $IconIndex 45
			${Break} 

		${Case} "APE"
			StrCpy $IconIndex 44
			${Break} 	
		
		${Case} "OFR"
			StrCpy $IconIndex 85
			${Break} 

		${Case} "OGG"
			StrCpy $IconIndex 28
			${Break} 	

		${Case} "WV"
			StrCpy $IconIndex 121
			${Break} 

		${Case} "AC3"
			StrCpy $IconIndex 46
			${Break} 	

		${Case} "DTS"
			StrCpy $IconIndex 58
			${Break} 

		${Case} "WAV"
			StrCpy $IconIndex 15
			${Break} 

		${Case} "AIFF"
			StrCpy $IconIndex 50
			${Break} 	

		${Case} "AIFC"
			StrCpy $IconIndex 49
			${Break} 

		${Case} "AU"
			StrCpy $IconIndex 51
			${Break} 	

		${Case} "AMR"
			StrCpy $IconIndex 123
			${Break} 

		${Case} "IT"
			StrCpy $IconIndex 65
			${Break} 

		${Case} "M2A"
			StrCpy $IconIndex 68
			${Break} 	

		${Case} "MO3"
			StrCpy $IconIndex 75
			${Break} 

		${Case} "MTM"
			StrCpy $IconIndex 83
			${Break} 	

		${Case} "S3M"
			StrCpy $IconIndex 93
			${Break} 

		${Case} "MIDI"
			StrCpy $IconIndex 71
			${Break} 

		${Case} "M1A"
			StrCpy $IconIndex 67
			${Break} 	

		${Case} "MOD"
			StrCpy $IconIndex 76
			${Break} 

		${Case} "RMI"
			StrCpy $IconIndex 89
			${Break} 	

		${Case} "SND"
			StrCpy $IconIndex 95
			${Break} 

		${Case} "UMX"
			StrCpy $IconIndex 100
			${Break} 

		${Case} "XM"
			StrCpy $IconIndex 108
			${Break} 	

		${Case} "ARM"
			StrCpy $IconIndex 112
			${Break} 

		${Case} "AVC-TS"
			StrCpy $IconIndex 113
			${Break} 	

		${Case} "SHN"
			StrCpy $IconIndex 119
			${Break} 

		${Case} "WV"
			StrCpy $IconIndex 121
			${Break} 

		${Case} "EC3"
			StrCpy $IconIndex 129
			${Break} 	

		${Case} "EAC3"
			StrCpy $IconIndex 128
			${Break} 

		${Case} "EVO"
			StrCpy $IconIndex 130
			${Break} 

		${Case} "LPCM"
			StrCpy $IconIndex 132
			${Break} 	

		${Case} "MLP"
			StrCpy $IconIndex 133
			${Break} 

		${Case} "MT9"
			StrCpy $IconIndex 134
			${Break} 

		${Case} "PCM"
			StrCpy $IconIndex 135
			${Break} 	

		${Case} "THD"
			StrCpy $IconIndex 139
			${Break} 
;....................................................................................
	; subtitles   
		
		${Case} "SMI"
			StrCpy $IconIndex 18
			${Break} 
		
		${Case} "RT"
			StrCpy $IconIndex 31
			${Break} 	

		${Case} "SUB"
			StrCpy $IconIndex 32
			${Break} 
		
		${Case} "IDX"
			StrCpy $IconIndex 33
			${Break} 	

		${Case} "ASS"
			StrCpy $IconIndex 34
			${Break} 
		
		${Case} "SSA"
			StrCpy $IconIndex 35
			${Break} 	

		${Case} "RSB"
			StrCpy $IconIndex 36
			${Break} 
		
		${Case} "SRT"
			StrCpy $IconIndex 37
			${Break} 	

		${Case} "S2K"
			StrCpy $IconIndex 38
			${Break} 	

		${Case} "MKS"
			StrCpy $IconIndex 73
			${Break} 	
;....................................................................................
	; playlists
		${Case} "ASX"
			StrCpy $IconIndex 1
			${Break} 	

		${Case} "WAX"
			StrCpy $IconIndex 102
			${Break} 

		${Case} "M3U"
			StrCpy $IconIndex 20
			${Break} 

		${Case} "PLS"
			StrCpy $IconIndex 19
			${Break} 	

		${Case} "WMX"
			StrCpy $IconIndex 105
			${Break} 

		${Case} "WPL"
			StrCpy $IconIndex 106
			${Break} 

		${Case} "WVX"
			StrCpy $IconIndex 107
			${Break} 

;....................................................................................
	; real media
		${Case} "RA"
			StrCpy $IconIndex 21
			${Break} 	

		${Case} "RM"
			StrCpy $IconIndex 22
			${Break} 

		${Case} "RMJ"
			StrCpy $IconIndex 23
			${Break} 

		${Case} "RMS"
			StrCpy $IconIndex 24
			${Break} 	

		${Case} "RAM"
			StrCpy $IconIndex 25
			${Break} 

		${Case} "RMM"
			StrCpy $IconIndex 26
			${Break} 

		${Case} "RMVB"
			StrCpy $IconIndex 27
			${Break} 

		${Case} "RPM"
			StrCpy $IconIndex 91
			${Break} 

		${Case} "RV"
			StrCpy $IconIndex 82
			${Break} 

;....................................................................................
	; other  
		${Case} "FLC"
			StrCpy $IconIndex 59
			${Break} 	

		${Case} "FLI"
			StrCpy $IconIndex 60
			${Break} 	

		${Case} "FLIC"
			StrCpy $IconIndex 61
			${Break} 	

		${Case} "PVA"
			StrCpy $IconIndex 88
			${Break} 

		${Case} "SWF"
			StrCpy $IconIndex 96
			${Break} 

		${Case} "WM"
			StrCpy $IconIndex 103
			${Break} 	

		${Case} "K3G"
			StrCpy $IconIndex 122
			${Break} 

		${Case} "M2T"
			StrCpy $IconIndex 124
			${Break} 

		${Case} "MTS"
			StrCpy $IconIndex 125
			${Break} 

		${Case} "SKM"
			StrCpy $IconIndex 126
			${Break} 

		${Case} "PMF"
			StrCpy $IconIndex 136
			${Break} 

		${Case} "M2TS"
			StrCpy $IconIndex 116
			${Break} 

		${Case} "KPL"
			StrCpy $IconIndex 0
			${Break} 

		${Case} "KSF"
			StrCpy $IconIndex 0
			${Break} 
;....................................................................................
	; ddefault icon	
		${Default}
			StrCpy $IconIndex 0
			${Break}	

	${EndSwitch}
  WriteRegStr HKCR "$ClassName\DefaultIcon" "" "$IconFile,$IconIndex"	
  EndMacro:
!macroend

!macro UnRegisterExtension extenstion
  StrCpy $ClassName "AIMP.${extenstion}"
  
  StrCmp ${extenstion} "AUDIOCD" 0 +7
	ReadRegStr $0 HKCR "${extenstion}" ""
	StrCmp $0	$ClassName 0 +2
	DeleteRegKey HKCR "$ClassName"
	ReadRegStr $0 HKCR "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\${extenstion}\UserChoice" ""
	StrCmp $0	$ClassName 0 +2
	DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\${extenstion}\UserChoice"

	ReadRegStr $0 HKCR ".${extenstion}" ""
  StrCmp $0	$ClassName 0 +2
  DeleteRegKey HKCR "$ClassName"
  
  ReadRegStr $0 HKCR "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.${extenstion}\UserChoice" ""
  StrCmp $0	$ClassName 0 +2
  DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.${extenstion}\UserChoice"
!macroend

;sections
Section "!${PRODUCT_NAME}" CORE
	SectionIn 1 2 3 RO
	StrCmp $gMode 1 EndSection
	
	;this is required section so don't perfom reading from inifile
	IfSilent 0 NotSilent
	IfFileExists $IniFile 0 NotSilent
	ReadINIStr $R0 $IniFile Advanced Directory
	StrCmp $R0 "" NotSilent 0
	StrCpy $SysDrive $WINDIR 2
	${WordReplace} $R0 "%programfiles%" "$PROGRAMFILES" "+" $R1
	${WordReplace} $R1 "%windir%" "$WINDIR" "+" $R0
	${WordReplace} $R0 "%appdata%" "$APPDATA" "+" $R1
	${WordReplace} $R1 "%systemdrive%" "$SysDrive" "+" $R0
	StrCpy $INSTDIR $R0	
NotSilent:
	SetOutPath "$INSTDIR\"
	File /r "${pkgdir}\${PRODUCT_NAME}\Player\*.*"
	
	StrCpy $OpenCommand "$INSTDIR\KMPlayer.exe $\"%1$\""	
	StrCpy $IconFileName "KIconLib.dll"
	StrCpy $IconFile "$INSTDIR\$IconFileName"
	
	WriteUninstaller "$OUTDIR\uninst.exe"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$OUTDIR\KMPlayer.exe"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$OUTDIR\uninst.exe"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${Publisher}"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Contact" "${Contact}"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "HelpLink" "${HelpLink}"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${URLInfoAbout}"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLUpdateInfo" "${URLUpdateInfo}" 
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Comments" "${Comments}"
	
	;   
	;WriteRegStr HKCU "Software\KMPlayer\KMP2.0\OptionArea" "SkinFolder" "Vista-Blue.ksf"
	;   
	WriteRegStr HKCU "Software\KMPlayer\KMP2.0\OptionArea" "LanguageIniName" "Russian.ini"
	;  
	WriteRegDWORD HKCU "Software\KMPlayer\KMP2.0\OptionArea" "AdvancedMenu" 0x1
	WriteRegDWORD HKCU "Software\KMPlayer\KMP2.0\OptionArea\KMPlayer.exe" "AdvancedMenu" 0x1	
EndSection:
SectionEnd

SectionGroup /e ""
	Section "" Skins
		SectionIn 1
		;read/write section state
		!insertmacro ProcessSection "Skins"
		;if $r0 is 0 then exit section
		StrCmp $R0 0 EndSection 0
		;--------------section code----------------		
		SetOutPath "$INSTDIR\Skins"
		File "${pkgdir}\${PRODUCT_NAME}\Skins\*.*"
		;-------------------------------------------
		EndSection:		
	SectionEnd

	Section "  " Icons
		SectionIn 1
		!insertmacro ProcessSection "Icons"
		;if $r0 is 0 then exit section
		StrCmp $R0 0 EndSection 0
		;--------------section code----------------			
		SetOutPath "$INSTDIR\Icons"
		File "${pkgdir}\${PRODUCT_NAME}\Icons\*.*"		
		
		IfSilent 0 EndSection
		IfFileExists $IniFile 0 EndSection
		ReadINIStr $R0 $IniFile Advanced IconFileName
			IfFileExists "$INSTDIR\Icons\$R0" 0 Checks2
			StrCpy $IconFileName $R0
			StrCpy $IconFile "$INSTDIR\Icons\$IconFileName"
		Checks2:
			IfFileExists "$INSTDIR\$R0" 0 EndSection
			StrCpy $IconFileName $R0
			StrCpy $IconFile "$INSTDIR\$IconFileName"
		;-------------------------------------------
		EndSection:			
	SectionEnd
SectionGroupEnd	

;=========================================================================================================================
SectionGroup /e ""
	Section "  " StartMenu
		SectionIn 1 2
		!insertmacro ProcessSection "StartMenu"
		;if $r0 is 0 then exit section
		StrCmp $R0 0 EndSection 0
		;--------------section code----------------		
		SetShellVarContext all
		SetOutPath "$INSTDIR"
		CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
		CreateShortCut  "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk" "$INSTDIR\KMPlayer.exe"
		CreateShortCut  "$SMPROGRAMS\${PRODUCT_NAME}\ ${PRODUCT_NAME}.lnk" "$INSTDIR\uninst.exe"

		;-------------------------------------------
		EndSection:	
	SectionEnd
	Section "  " Desktop
		SectionIn 1
		!insertmacro ProcessSection "Desktop"
		;if $r0 is 0 then exit section
		StrCmp $R0 0 EndSection 0		
		;--------------section code----------------	
		SetShellVarContext all
		SetOutPath "$INSTDIR"
		CreateShortCut "$DESKTOP\${PRODUCT_NAME}.lnk" "$INSTDIR\KMPlayer.exe"
		;-------------------------------------------
		EndSection:	
	SectionEnd
	Section "   " QuickLaunch
		SectionIn 1
		!insertmacro ProcessSection "QuickLaunch"
		;if $r0 is 0 then exit section
		StrCmp $R0 0 EndSection 0		
		;--------------section code----------------	
		SetShellVarContext all
		SetOutPath "$INSTDIR"
		CreateShortCut "$QUICKLAUNCH\${PRODUCT_NAME}.lnk" "$INSTDIR\KMPlayer.exe"
		;-------------------------------------------
		EndSection:	
	SectionEnd	
SectionGroupEnd	

SectionGroup ""
	
	Section "DVD-"
		SectionIn 1
		!insertmacro ProcessSection "autorundvd"
		;if $r0 is 0 then exit section
		StrCmp $R0 0 EndSection 0
		
		;--------------section code----------------	
		WriteRegStr HKCR "DVD\shell" "" "The KMPlayer"
		WriteRegStr HKCR "DVD\shell\The KMPlayer\command" "" "$\"$INSTDIR\KMPlayer.exe$\" $\"%1$\" /dvd"
		EndSection:
	SectionEnd

	Section "-"
		SectionIn 1
		!insertmacro ProcessSection "autoruncd"
		;if $r0 is 0 then exit section
		StrCmp $R0 0 EndSection 0
		
		;--------------section code----------------			
		WriteRegStr HKCR "AudioCD\shell" "" "The KMPlayer"
		WriteRegStr HKCR "AudioCD\shell\The KMPlayer\command" "" "$\"$INSTDIR\KMPlayer.exe$\" $\"%1$\" /cd"
		EndSection:		
	SectionEnd
SectionGroupEnd

SectionGroup /e " "
	SectionGroup ""
		; video

		Section "ASF"
			SectionIn 1 2
			!insertmacro RegisterExtension "ASF" 0
		SectionEnd
		
		Section "AVI"
			SectionIn 1 2
			!insertmacro RegisterExtension "AVI" 0
		SectionEnd

		Section "WMV"
			SectionIn 1 2
			!insertmacro RegisterExtension "WMV" 0
		SectionEnd

		Section "FLV"
			SectionIn 1 2
			!insertmacro RegisterExtension "FLV" 0
		SectionEnd

		Section "MKV"
			SectionIn 1 2
			!insertmacro RegisterExtension "MKV" 0
		SectionEnd

		Section "MOV"
			SectionIn 1 2
			!insertmacro RegisterExtension "MOV" 0
		SectionEnd

		Section "3GP"
			SectionIn 1 2
			!insertmacro RegisterExtension "3GP" 0
		SectionEnd
		
		Section "DIVX"
			SectionIn 1 2
			!insertmacro RegisterExtension "DIVX" 0
		SectionEnd

		Section "MP4"
			SectionIn 1 2
			!insertmacro RegisterExtension "MP4" 0
		SectionEnd

		Section "MPG"
			SectionIn 1 2
			!insertmacro RegisterExtension "MPG" 0
		SectionEnd
		
		Section "MPEG"
			SectionIn 1 2
			!insertmacro RegisterExtension "MPEG" 0
		SectionEnd
		
		Section "MPE"
			SectionIn 1 2
			!insertmacro RegisterExtension "MPE" 0
		SectionEnd

		Section "DAT"
			SectionIn 1 2
			!insertmacro RegisterExtension "DAT" 0
		SectionEnd
		
		Section "VOB"
			SectionIn 1 2
			!insertmacro RegisterExtension "VOB" 0
		SectionEnd
		
		Section "IFO"
			SectionIn 1 2
			!insertmacro RegisterExtension "IFO" 0
		SectionEnd

		Section "M1V"
			SectionIn 1 2
			!insertmacro RegisterExtension "M1V" 0
		SectionEnd
		
		Section "M2V"
			SectionIn 1 2
			!insertmacro RegisterExtension "M2V" 0
		SectionEnd

		Section "M4V"
			SectionIn 1 2
			!insertmacro RegisterExtension "M4V" 0
		SectionEnd
		
		Section "MMS"
			SectionIn 1 2
			!insertmacro RegisterExtension "MMS" 0
		SectionEnd
		
		Section "OGM"
			SectionIn 1 2
			!insertmacro RegisterExtension "OGM" 0
		SectionEnd

		Section "QT"
			SectionIn 1 2
			!insertmacro RegisterExtension "QT" 0
		SectionEnd
		
		Section "TS"
			SectionIn 1 2
			!insertmacro RegisterExtension "TS" 0
		SectionEnd

		Section "VP6"
			SectionIn 1 2
			!insertmacro RegisterExtension "VP6" 0
		SectionEnd
		
		Section "XVID"
			SectionIn 1 2
			!insertmacro RegisterExtension "XVID" 0
		SectionEnd
		
		Section "3G2"
			SectionIn 1 2
			!insertmacro RegisterExtension "3G2" 0
		SectionEnd
		
		Section "TP"
			SectionIn 1 2
			!insertmacro RegisterExtension "TP" 0
		SectionEnd

		Section "AVI-Neo"
			SectionIn 1 2
			!insertmacro RegisterExtension "AVI-Neo" 0
		SectionEnd

		Section "BIK"
			SectionIn 1 2
			!insertmacro RegisterExtension "BIK" 0
		SectionEnd
		
		Section "D2V"
			SectionIn 1 2
			!insertmacro RegisterExtension "D2V" 0
		SectionEnd
		
		Section "DRC"
			SectionIn 1 2
			!insertmacro RegisterExtension "DRC" 0
		SectionEnd
		
		Section "IFV"
			SectionIn 1 2
			!insertmacro RegisterExtension "IFV" 0
		SectionEnd

		Section "MP2V"
			SectionIn 1 2
			!insertmacro RegisterExtension "MP2V" 0
		SectionEnd

		Section "MPV2"
			SectionIn 1 2
			!insertmacro RegisterExtension "MPV2" 0
		SectionEnd
		
		Section "MQV"
			SectionIn 1 2
			!insertmacro RegisterExtension "MQV" 0
		SectionEnd
		
		Section "PART"
			SectionIn 1 2
			!insertmacro RegisterExtension "PART" 0
		SectionEnd
		
		Section "PSS"
			SectionIn 1 2
			!insertmacro RegisterExtension "PSS" 0
		SectionEnd

		Section "ROQ"
			SectionIn 1 2
			!insertmacro RegisterExtension "ROQ" 0
		SectionEnd

		Section "SMK"
			SectionIn 1 2
			!insertmacro RegisterExtension "SMK" 0
		SectionEnd
		
		Section "TPR"
			SectionIn 1 2
			!insertmacro RegisterExtension "TPR" 0
		SectionEnd
		
		Section "TRP"
			SectionIn 1 2
			!insertmacro RegisterExtension "TRP" 0
		SectionEnd
		
		Section "DVR-MS"
			SectionIn 1 2
			!insertmacro RegisterExtension "DVR-MS" 0
		SectionEnd

		Section "GVI"
			SectionIn 1 2
			!insertmacro RegisterExtension "GVI" 0
		SectionEnd
		
		Section "NSV"
			SectionIn 1 2
			!insertmacro RegisterExtension "NSV" 0
		SectionEnd
		
		Section "PMP"
			SectionIn 1 2
			!insertmacro RegisterExtension "PMP" 0
		SectionEnd
		
		Section "VP7"
			SectionIn 1 2
			!insertmacro RegisterExtension "VP7" 0
		SectionEnd

		Section "264"
			SectionIn 1 2
			!insertmacro RegisterExtension "264" 0
		SectionEnd
		
		Section "H264"
			SectionIn 1 2
			!insertmacro RegisterExtension "H264" 0
		SectionEnd
		
		Section "VC1"
			SectionIn 1 2
			!insertmacro RegisterExtension "VC1" 0
		SectionEnd
	SectionGroupEnd	
;....................................................................................
	SectionGroup ""	
		; audio   

		Section "MP3"
			SectionIn 1 
			!insertmacro RegisterExtension "MP3" 0
		SectionEnd
		
		Section "AAC"
			SectionIn 1 
			!insertmacro RegisterExtension "AAC" 0
		SectionEnd
		
		Section "WMA"
			SectionIn 1 
			!insertmacro RegisterExtension "WMA" 0
		SectionEnd

		Section "CDA"
			SectionIn 1 
			!insertmacro RegisterExtension "CDA" 0
		SectionEnd
		
		Section "FLAC"
			SectionIn 1 
			!insertmacro RegisterExtension "FLAC" 0
		SectionEnd

		Section "M4A"
			SectionIn 1 
			!insertmacro RegisterExtension "M4A" 0
		SectionEnd	
		
		Section "MID"
			SectionIn 1 
			!insertmacro RegisterExtension "MID" 0
		SectionEnd

		Section "MKA"
			SectionIn 1 
			!insertmacro RegisterExtension "MKA" 0
		SectionEnd	
		
		Section "MP2"
			SectionIn 1 
			!insertmacro RegisterExtension "MP2" 0
		SectionEnd 

		Section "MPA"
			SectionIn 1 
			!insertmacro RegisterExtension "MPA" 0
		SectionEnd	

		Section "MPC"
			SectionIn 1 
			!insertmacro RegisterExtension "MPC" 0
		SectionEnd

		Section "APE"
			SectionIn 1 
			!insertmacro RegisterExtension "APE" 0
		SectionEnd
			
		Section "OFR"
			SectionIn 1 
			!insertmacro RegisterExtension "OFR" 0
		SectionEnd

		Section "OGG"
			SectionIn 1 
			!insertmacro RegisterExtension "OGG" 0
		SectionEnd

		Section "WV"
			SectionIn 1 
			!insertmacro RegisterExtension "WV" 0
		SectionEnd

		Section "AC3"
			SectionIn 1 
			!insertmacro RegisterExtension "AC3" 0
		SectionEnd

		Section "DTS"
			SectionIn 1 
			!insertmacro RegisterExtension "DTS" 0
		SectionEnd

		Section "WAV"
			SectionIn 1 
			!insertmacro RegisterExtension "WAV" 0
		SectionEnd

		Section "AIFF"
			SectionIn 1 
			!insertmacro RegisterExtension "AIFF" 0
		SectionEnd	

		Section "AIFC"
			SectionIn 1 
			!insertmacro RegisterExtension "AIFC" 0
		SectionEnd

		Section "AU"
			SectionIn 1 
			!insertmacro RegisterExtension "AU" 0
		SectionEnd

		Section "AMR"
			SectionIn 1 
			!insertmacro RegisterExtension "AMR" 0
		SectionEnd

		Section "IT"
			SectionIn 1 
			!insertmacro RegisterExtension "IT" 0
		SectionEnd

		Section "M2A"
			SectionIn 1 
			!insertmacro RegisterExtension "M2A" 0
		SectionEnd	

		Section "MO3"
			SectionIn 1 
			!insertmacro RegisterExtension "MO3" 0
		SectionEnd

		Section "MTM"
			SectionIn 1 
			!insertmacro RegisterExtension "MTM" 0
		SectionEnd

		Section "S3M"
			SectionIn 1 
			!insertmacro RegisterExtension "S3M" 0
		SectionEnd

		Section "MIDI"
			SectionIn 1 
			!insertmacro RegisterExtension "MIDI" 0
		SectionEnd

		Section "M1A"
			SectionIn 1 
			!insertmacro RegisterExtension "M1A" 0
		SectionEnd

		Section "MOD"
			SectionIn 1 
			!insertmacro RegisterExtension "MOD" 0
		SectionEnd

		Section "RMI"
			SectionIn 1 
			!insertmacro RegisterExtension "RMI" 0
		SectionEnd

		Section "SND"
			SectionIn 1 
			!insertmacro RegisterExtension "SND" 0
		SectionEnd

		Section "UMX"
			SectionIn 1 
			!insertmacro RegisterExtension "UMX" 0
		SectionEnd

		Section "XM"
			SectionIn 1 
			!insertmacro RegisterExtension "XM" 0
		SectionEnd

		Section "ARM"
			SectionIn 1 
			!insertmacro RegisterExtension "ARM" 0
		SectionEnd

		Section "AVC-TS"
			SectionIn 1 
			!insertmacro RegisterExtension "AVC-TS" 0
		SectionEnd

		Section "SHN"
			SectionIn 1 
			!insertmacro RegisterExtension "SHN" 0
		SectionEnd

		Section "EC3"
			SectionIn 1 
			!insertmacro RegisterExtension "EC3" 0
		SectionEnd

		Section "EAC3"
			SectionIn 1 
			!insertmacro RegisterExtension "EAC3" 0
		SectionEnd

		Section "EVO"
			SectionIn 1 
			!insertmacro RegisterExtension "EVO" 0
		SectionEnd

		Section "LPCM"
			SectionIn 1 
			!insertmacro RegisterExtension "LPCM" 0
		SectionEnd

		Section "PCM"
			SectionIn 1 
			!insertmacro RegisterExtension "PCM" 0
		SectionEnd

		Section "MLP"
			SectionIn 1 
			!insertmacro RegisterExtension "MLP" 0
		SectionEnd

		Section "MT9"
			SectionIn 1 
			!insertmacro RegisterExtension "MT9" 0
		SectionEnd

		Section "THD"
			SectionIn 1 
			!insertmacro RegisterExtension "THD" 0
		SectionEnd
	SectionGroupEnd	
;....................................................................................
	SectionGroup ""
		; subtitles   
			
		Section "SMI"
			SectionIn 1 2
			!insertmacro RegisterExtension "SMI" 0
		SectionEnd
			
		Section "RT"
			SectionIn 1 2
			!insertmacro RegisterExtension "RT" 0
		SectionEnd

		Section "SUB"
			SectionIn 1 2
			!insertmacro RegisterExtension "SUB" 0
		SectionEnd
			
		Section "IDX"
			SectionIn 1 2
			!insertmacro RegisterExtension "IDX" 0
		SectionEnd

		Section "ASS"
			SectionIn 1 2
			!insertmacro RegisterExtension "ASS" 0
		SectionEnd
			
		Section "SSA"
			SectionIn 1 2
			!insertmacro RegisterExtension "SSA" 0
		SectionEnd

		Section "RSB"
			SectionIn 1 2
			!insertmacro RegisterExtension "RSB" 0
		SectionEnd
			
		Section "SRT"
			SectionIn 1 2
			!insertmacro RegisterExtension "SRT" 0
		SectionEnd

		Section "S2K"
			SectionIn 1 2
			!insertmacro RegisterExtension "S2K" 0
		SectionEnd

		Section "MKS"
			SectionIn 1 2
			!insertmacro RegisterExtension "MKS"  0
		SectionEnd	
	SectionGroupEnd	
;....................................................................................
	SectionGroup ""
		; playlists

		Section "ASX"
			SectionIn 1 
			!insertmacro RegisterExtension "ASX" 0
		SectionEnd

		Section "M3U"
			SectionIn 1 
			!insertmacro RegisterExtension "M3U" 0
		SectionEnd

		Section "PLS"
			SectionIn 1 
			!insertmacro RegisterExtension "PLS" 0
		SectionEnd

		Section "WPL"
			SectionIn 1 
			!insertmacro RegisterExtension "WPL" 0
		SectionEnd

		Section "WAX"
			SectionIn 1 
			!insertmacro RegisterExtension "WAX" 0
		SectionEnd

		Section "WMX"
			SectionIn 1 
			!insertmacro RegisterExtension "WMX" 0
		SectionEnd

		Section "WVX"
			SectionIn 1 
			!insertmacro RegisterExtension "WVX" 0
		SectionEnd
	SectionGroupEnd	
;....................................................................................
	SectionGroup "Real Media"
		; real media

		Section "RA"
			SectionIn 1 
			!insertmacro RegisterExtension "RA" 0
		SectionEnd

		Section "RM"
			SectionIn 1 
			!insertmacro RegisterExtension "RM" 0
		SectionEnd

		Section "RMJ"
			SectionIn 1 
			!insertmacro RegisterExtension "RMJ" 0
		SectionEnd

		Section "RMS"
			SectionIn 1 
			!insertmacro RegisterExtension "RMS" 0
		SectionEnd	

		Section "RAM"
			SectionIn 1 
			!insertmacro RegisterExtension "RAM" 0
		SectionEnd

		Section "RMM"
			SectionIn 1 
			!insertmacro RegisterExtension "RMM" 0
		SectionEnd 

		Section "RMVB"
			SectionIn 1 
			!insertmacro RegisterExtension "RMVB" 0
		SectionEnd

		Section "RPM"
			SectionIn 1 
			!insertmacro RegisterExtension "RPM" 0
		SectionEnd

		Section "RV"
			SectionIn 1 
			!insertmacro RegisterExtension "RV" 0
		SectionEnd
	SectionGroupEnd	
;....................................................................................
	SectionGroup ""
		; other  

		Section "FLC"
			SectionIn 1 
			!insertmacro RegisterExtension "FLC" 0
		SectionEnd

		Section "FLI"
			SectionIn 1 
			!insertmacro RegisterExtension "FLI" 0
		SectionEnd

		Section "FLIC"
			SectionIn 1 
			!insertmacro RegisterExtension "FLIC" 0
		SectionEnd

		Section "PVA"
			SectionIn 1 
			!insertmacro RegisterExtension "PVA" 0
		SectionEnd

		Section "SWF"
			SectionIn 1 
			!insertmacro RegisterExtension "SWF" 0
		SectionEnd

		Section "WM"
			SectionIn 1 
			!insertmacro RegisterExtension "WM" 0
		SectionEnd

		Section "K3G"
			SectionIn 1 
			!insertmacro RegisterExtension "K3G" 0
		SectionEnd 

		Section "M2T"
			SectionIn 1 
			!insertmacro RegisterExtension "M2T" 0
		SectionEnd

		Section "M2TS"
			SectionIn 1 
			!insertmacro RegisterExtension "M2TS" 0
		SectionEnd

		Section "MTS"
			SectionIn 1 
			!insertmacro RegisterExtension "MTS" 0
		SectionEnd

		Section "SKM"
			SectionIn 1 
			!insertmacro RegisterExtension "SKM" 0
		SectionEnd

		Section "PMF"
			SectionIn 1 
			!insertmacro RegisterExtension "PMF" 0
		SectionEnd
		
	SectionGroupEnd	
;....................................................................................
SectionGroupEnd	

Section "-PostinstallProcessing"
	StrCmp $gMode 1 EndSection
	IfSilent 0 EndSection
	IfFileExists $IniFile 0 EndSection
	ReadINIStr $R0 $IniFile Advanced SkinFile
	WriteRegStr HKCU "Software\KMPlayer\KMP2.0\OptionArea" "SkinFolder" "$R0"
	EndSection:
SectionEnd
Section "-PostinstallProcessingKPL"
	StrCmp $gMode 1 EndSection
	!insertmacro RegisterExtension "KPL" 1
	EndSection:
SectionEnd

Section "-PostinstallProcessingKSF"
	StrCmp $gMode 1 EndSection
	!insertmacro RegisterExtension "KSF" 1
	${RefreshShellIcons}	
	EndSection:
SectionEnd


Section Uninstall
	RMDir /r "$INSTDIR\"
	SetShellVarContext all
	RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}"
	Delete "$DESKTOP\${PRODUCT_NAME}.LNK"
	Delete "$QUICKLAUNCH\${PRODUCT_NAME}.LNK"
	DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
	!insertmacro UnRegisterExtension "ASF"
	!insertmacro UnRegisterExtension "AVI"
	!insertmacro UnRegisterExtension "WMV"
	!insertmacro UnRegisterExtension "FLV"
	!insertmacro UnRegisterExtension "MKV"
	!insertmacro UnRegisterExtension "MOV"
	!insertmacro UnRegisterExtension "3GP"
	!insertmacro UnRegisterExtension "DIVX"
	!insertmacro UnRegisterExtension "MP4"
	!insertmacro UnRegisterExtension "MPG"
	!insertmacro UnRegisterExtension "MPEG"
	!insertmacro UnRegisterExtension "MPE"
	!insertmacro UnRegisterExtension "DAT"
	!insertmacro UnRegisterExtension "VOB"
	!insertmacro UnRegisterExtension "IFO"
	!insertmacro UnRegisterExtension "M1V"
	!insertmacro UnRegisterExtension "M2V"
	!insertmacro UnRegisterExtension "M4V"
	!insertmacro UnRegisterExtension "MMS"
	!insertmacro UnRegisterExtension "OGM"
	!insertmacro UnRegisterExtension "QT"
	!insertmacro UnRegisterExtension "TS"
	!insertmacro UnRegisterExtension "VP6"
	!insertmacro UnRegisterExtension "XVID"
	!insertmacro UnRegisterExtension "3G2"
	!insertmacro UnRegisterExtension "TP"
	!insertmacro UnRegisterExtension "AVI-Neo"
	!insertmacro UnRegisterExtension "BIK"
	!insertmacro UnRegisterExtension "D2V"
	!insertmacro UnRegisterExtension "DRC"
	!insertmacro UnRegisterExtension "IFV"
	!insertmacro UnRegisterExtension "MP2V"
	!insertmacro UnRegisterExtension "MPV2"
	!insertmacro UnRegisterExtension "MQV"
	!insertmacro UnRegisterExtension "PART"
	!insertmacro UnRegisterExtension "PSS"
	!insertmacro UnRegisterExtension "ROQ"
	!insertmacro UnRegisterExtension "SMK"
	!insertmacro UnRegisterExtension "TPR"
	!insertmacro UnRegisterExtension "TRP"
	!insertmacro UnRegisterExtension "DVR-MS"
	!insertmacro UnRegisterExtension "GVI"
	!insertmacro UnRegisterExtension "NSV"
	!insertmacro UnRegisterExtension "PMP"
	!insertmacro UnRegisterExtension "VP7"
	!insertmacro UnRegisterExtension "MP3"
	!insertmacro UnRegisterExtension "AAC"
	!insertmacro UnRegisterExtension "WMA"
	!insertmacro UnRegisterExtension "CDA"
	!insertmacro UnRegisterExtension "FLAC"
	!insertmacro UnRegisterExtension "M4A"
	!insertmacro UnRegisterExtension "MID"
	!insertmacro UnRegisterExtension "MKA"
	!insertmacro UnRegisterExtension "MP2"
	!insertmacro UnRegisterExtension "MPA"
	!insertmacro UnRegisterExtension "MPC"
	!insertmacro UnRegisterExtension "APE"
	!insertmacro UnRegisterExtension "OFR"
	!insertmacro UnRegisterExtension "OGG"
	!insertmacro UnRegisterExtension "WV"
	!insertmacro UnRegisterExtension "AC3"
	!insertmacro UnRegisterExtension "DTS"
	!insertmacro UnRegisterExtension "WAV"
	!insertmacro UnRegisterExtension "AIFF"
	!insertmacro UnRegisterExtension "AIFC"
	!insertmacro UnRegisterExtension "AU"
	!insertmacro UnRegisterExtension "AMR"
	!insertmacro UnRegisterExtension "IT"
	!insertmacro UnRegisterExtension "M2A"
	!insertmacro UnRegisterExtension "MO3"
	!insertmacro UnRegisterExtension "MTM"
	!insertmacro UnRegisterExtension "S3M"
	!insertmacro UnRegisterExtension "MIDI"
	!insertmacro UnRegisterExtension "M1A"
	!insertmacro UnRegisterExtension "MOD"
	!insertmacro UnRegisterExtension "RMI"
	!insertmacro UnRegisterExtension "SND"
	!insertmacro UnRegisterExtension "UMX"
	!insertmacro UnRegisterExtension "XM"
	!insertmacro UnRegisterExtension "ARM"
	!insertmacro UnRegisterExtension "AVC-TS"
	!insertmacro UnRegisterExtension "SHN"
	!insertmacro UnRegisterExtension "SMI"
	!insertmacro UnRegisterExtension "RT"
	!insertmacro UnRegisterExtension "SUB"
	!insertmacro UnRegisterExtension "IDX"
	!insertmacro UnRegisterExtension "ASS"
	!insertmacro UnRegisterExtension "SSA"
	!insertmacro UnRegisterExtension "RSB"
	!insertmacro UnRegisterExtension "SRT"
	!insertmacro UnRegisterExtension "S2K"
	!insertmacro UnRegisterExtension "MKS" 
	!insertmacro UnRegisterExtension "ASX"
	!insertmacro UnRegisterExtension "M3U"
	!insertmacro UnRegisterExtension "PLS"
	!insertmacro UnRegisterExtension "WPL"
	!insertmacro UnRegisterExtension "WAX"
	!insertmacro UnRegisterExtension "WMX"
	!insertmacro UnRegisterExtension "WVX"
	!insertmacro UnRegisterExtension "RA"
	!insertmacro UnRegisterExtension "RM"
	!insertmacro UnRegisterExtension "RMJ"
	!insertmacro UnRegisterExtension "RMS"
	!insertmacro UnRegisterExtension "RAM"
	!insertmacro UnRegisterExtension "RMM"
	!insertmacro UnRegisterExtension "RMVB"
	!insertmacro UnRegisterExtension "RPM"
	!insertmacro UnRegisterExtension "RV"
	!insertmacro UnRegisterExtension "FLC"
	!insertmacro UnRegisterExtension "FLI"
	!insertmacro UnRegisterExtension "FLIC"
	!insertmacro UnRegisterExtension "PVA"
	!insertmacro UnRegisterExtension "SWF"
	!insertmacro UnRegisterExtension "WM"
	!insertmacro UnRegisterExtension "K3G"
	!insertmacro UnRegisterExtension "M2T"
	!insertmacro UnRegisterExtension "MTS"
	!insertmacro UnRegisterExtension "SKM"
	!insertmacro UnRegisterExtension "KPL"
	!insertmacro UnRegisterExtension "KSF"
	!insertmacro UnRegisterExtension "M2TS"
	!insertmacro UnRegisterExtension "PMF"
	!insertmacro UnRegisterExtension "EC3"
	!insertmacro UnRegisterExtension "EAC3"
	!insertmacro UnRegisterExtension "EVO"
	!insertmacro UnRegisterExtension "LPCM"
	!insertmacro UnRegisterExtension "PCM"
	!insertmacro UnRegisterExtension "MLP"
	!insertmacro UnRegisterExtension "MT9"
	!insertmacro UnRegisterExtension "THD"
	!insertmacro UnRegisterExtension "264"
	!insertmacro UnRegisterExtension "H264"
	!insertmacro UnRegisterExtension "VC1"
	DeleteRegKey HKCR "DVD\shell\The KMPlayer"
	DeleteRegKey HKCR "AudioCD\shell\The KMPlayer"
	DeleteRegKey HKCU "Software\KMPlayer"
	${RefreshShellIcons}
	SetAutoClose true
SectionEnd




;###################################################################################
Function onGUIInit
 BrandingURL::Set /NOUNLOAD "0" "0" "255" "http://oszone.net"
FunctionEnd

Function .onInit
	;
	; when /g switch specified and not present /s switch, then generate default config
	;
	;inifile definition
	;
	StrCpy $WindowCaption "${PRODUCT_NAME} ${PRODUCT_VERSION}"
	${WordReplace} "$EXEFILE" ".exe" ".ini" "+" $IniFile
	StrCpy $IniFile "$EXEDIR\$IniFile"
	
	;gMode detection
	StrCpy $gMode 0
	${GetOptions} $CMDLINE "/G" $0
	;if not found /G then exit
	IfErrors EndFunc 0
	;When Silent setup then ignoring /G
	IfSilent +4 0
	StrCpy $gMode 1
	Delete $IniFile
	StrCpy $WindowCaption "   ${PRODUCT_NAME}"
	EndFunc:
FunctionEnd

Function .onGUIEnd
 BrandingURL::Unload
FunctionEnd

;################### CUSTOM PAGE
Function nsDialogsPage
	IfSilent EndnsFunc
	StrCmp $gMode 1 0 EndnsFunc
	nsDialogs::Create 1018
	Pop $Dialog
	
	${NSD_CreateLabel} 0 5 118u 12u "   :"
	${NSD_CreateFileRequest} 120u 0u 100u 12u "KIconLib.dll"
	Pop $FileRequestIconDll
	;StrCpy $R2 "aimp classic2.dll"
	;SendMessage $FileRequestIconDll ${WM_SETTEXT} 0 STR:$R2
	${NSD_CreateBrowseButton} 220u 0 25 12u "..."
	Pop $BtnBrowseIconDll
	nsDialogs::SetUserData $BtnBrowseIconDll FileRequest # remember field id
	GetFunctionAddress $0 fnBtnBrowseIconDll
	nsDialogs::OnClick $BtnBrowseIconDll $0

	${NSD_CreateLabel} 0 45 118u 12u "   :"
	${NSD_CreateFileRequest} 120u 40 100u 12u ""
	Pop $FileRequestSkin
	;StrCpy $R2 "aimp classic2.dll"
	;SendMessage $FileRequestIconDll ${WM_SETTEXT} 0 STR:$R2
	${NSD_CreateBrowseButton} 220u 40 25 12u "..."
	Pop $BtnBrowseSkin
	nsDialogs::SetUserData $BtnBrowseSkin FileRequest # remember field id
	GetFunctionAddress $0 fnBtnBrowseSkin
	nsDialogs::OnClick $BtnBrowseSkin $0

	nsDialogs::Show
	
EndnsFunc:
FunctionEnd

Function nsDialogsPageLeave
	IfSilent EndnsFuncL
	StrCmp $gMode 1 0 EndnsFuncL
	${NSD_GetText} $FileRequestSkin $R2
	WriteINIStr $IniFile Advanced SkinFile $R2
	${NSD_GetText} $FileRequestIconDll $R2
	WriteINIStr $IniFile Advanced IconFileName $R2
	WriteINIStr $IniFile Advanced Directory $INSTDIR
EndnsFuncL:
FunctionEnd

Function fnBtnBrowseIconDll
	nsDialogs::SelectFileDialog open $R2 "*.dll|*.dll"
	Pop $R2
	${GetFileName} $R2 $R2
	${If} $R2 != ""
		SendMessage $FileRequestIconDll ${WM_SETTEXT} 0 STR:$R2
	${EndIf}
FunctionEnd

Function fnBtnBrowseSkin
	nsDialogs::SelectFileDialog open $R2 "*.ksf|*.ksf"
	Pop $R2
	${GetFileName} $R2 $R2
	${If} $R2 != ""
		SendMessage $FileRequestSkin ${WM_SETTEXT} 0 STR:$R2
	${EndIf}
FunctionEnd


