#define AppId "The KMPlayer"
#define AppName "The KMPlayer"
#define AppVersion "3.0.0.1438"
#define Appfile "KMPlayer.exe"
#define AppPublisherURL "http://www.kmplayer.com/forums/index.php"
#define VersionInfoCompany "Pandora.TV"

[Setup]
AppId={#AppId}
AppName={#AppName}
AppVerName={#AppName} {#AppVersion}
AppVersion={#AppVersion}
AppPublisherURL={#AppPublisherURL}
DefaultDirName={pf}\{#AppName}
DefaultGroupName={#AppId}
VersionInfoCompany={#VersionInfoCompany}
VersionInfoTextVersion={#AppVersion}
VersionInfoCopyright={#VersionInfoCompany}
SetupIconFile=KMPlayer.ico
OutputBaseFilename=KMPlayer
;WizardImageFile=compiler:WizModernImage-IS.bmp
WizardSmallImageFile=compiler:wizmodernsmallimage-IS.bmp
WizardImageFile=KMPlayer.bmp
;WizardSmallImageFile=modern-header.bmp
AppPublisher=Cleric
Compression=lzma2
SolidCompression=true
AllowNoIcons=true
WindowVisible=false
DirExistsWarning=yes
VersionInfoVersion={#AppVersion}
VersionInfoProductName={#AppName}
VersionInfoProductVersion={#AppVersion}
DisableFinishedPage=false
ShowLanguageDialog=no

[Types]
Name: full; Description:  
Name: custom; Description:  ; Flags: iscustom

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}
Name: quicklaunchicon; Description: {cm:CreateQuickLaunchIcon}; GroupDescription: {cm:AdditionalIcons}
Name: auto; Description:  CD/DVD; GroupDescription:  :
Name: auto\videodvd; Description: -DVD
Name: auto\videofile; Description:  
Name: auto\audiocd; Description: -CD; Flags: unchecked
Name: auto\audiofile; Description:  ; Flags: unchecked

Name: assoc; Description:  :; GroupDescription:  :
Name: assoc\video; Description: ; GroupDescription:  :
Name: assoc\audio; Description: ; GroupDescription:  :; Flags: unchecked
Name: assoc\subt; Description: ; GroupDescription:  :
Name: assoc\plst; Description: ; GroupDescription:  :
Name: assoc\real; Description: -; GroupDescription:  :
Name: assoc\other; Description: ; GroupDescription:  :

[Files]
Source: kmp\*; DestDir: {app}; Flags: IgnoreVersion recursesubdirs createallsubdirs

[Run]
Filename: {app}\{#Appfile}; WorkingDir: {app}; Description:  KMPlayer; Flags: postinstall unchecked nowait

[Icons]
Name: {group}\{#AppName}; Filename: {app}\{#Appfile}; WorkingDir: {app}; IconFilename: {app}\{#Appfile}
Name: {group}\ {#AppName}; Filename: {uninstallexe}; IconFilename: {app}\{#Appfile}
Name: {commondesktop}\{#AppName}; Filename: {app}\{#Appfile}; Tasks: desktopicon; WorkingDir: {app}
Name: {userappdata}\Microsoft\Internet Explorer\Quick Launch\{#AppName}; Filename: {app}\{#Appfile}; Tasks: quicklaunchicon; WorkingDir: {app}

[Registry]
;
Root: HKCU; SubKey: Software\KMPlayer; ValueType: none; Flags: uninsdeletekey
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: string; ValueName: SkinFolder; ValueData: Vista-Blue.ksf; Flags: uninsdeletevalue uninsdeletekeyifempty
;   
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: string; ValueName: LanguageIniName; ValueData: Russian.ini; Flags: uninsdeletevalue uninsdeletekeyifempty
;  
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AdvancedMenu; ValueData: $00000001; Flags: uninsdeletevalue uninsdeletekeyifempty
;   -  
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey4; ValueData: $00000001; Flags: uninsdeletevalue uninsdeletekeyifempty
;    2.0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AFOutputMode; ValueData: $00000002; Flags: uninsdeletevalue uninsdeletekeyifempty
; Flash Album List
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionAread; ValueType: string; ValueName: LogoImageName; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.TKMPDropTarget; ValueType: string; ValueData: KMPlayer; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.TKMPDropTarget\Clsid; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.TKMPDropTarget2; ValueType: string; ValueData: KMPlayer; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.TKMPDropTarget2\Clsid; ValueType: string; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
;
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 0; ValueData: ASF; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 1; ValueData: ASX; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 2; ValueData: AVI; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 3; ValueData: DAT; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 4; ValueData: M1V; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 5; ValueData: M2V; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 6; ValueData: MID; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 7; ValueData: MMS; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 8; ValueData: MOV; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 9; ValueData: MP3; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 10; ValueData: MPE; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 11; ValueData: MPEG; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 12; ValueData: MPG; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 13; ValueData: QT; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 14; ValueData: VOB; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 15; ValueData: WAV; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 16; ValueData: WMA; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 17; ValueData: WMV; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 18; ValueData: SMI; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 19; ValueData: PLS; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 20; ValueData: M3U; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 21; ValueData: RA; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 22; ValueData: RM; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 23; ValueData: RMJ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 24; ValueData: RMS; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 25; ValueData: RAM; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 26; ValueData: RMM; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 27; ValueData: RMVB; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 28; ValueData: OGG; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 29; ValueData: OGM; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 30; ValueData: MKV; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 31; ValueData: RT; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 32; ValueData: SUB; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 33; ValueData: IDX; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 34; ValueData: ASS; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 35; ValueData: SSA; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 36; ValueData: PSB; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 37; ValueData: SRT; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 38; ValueData: S2K; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 39; ValueData: avi_NEO_; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 40; ValueData: IFO; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 41; ValueData: FLAC; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 42; ValueData: AAC; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 43; ValueData: MP4; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 44; ValueData: APE; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 45; ValueData: MPC; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 46; ValueData: AC3; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 47; ValueData: FLV; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 48; ValueData: 3GP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 49; ValueData: TS; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 50; ValueData: TP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 51; ValueData: CDA; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 52; ValueData: M4A; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 53; ValueData: MKA; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 54; ValueData: MP2; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 55; ValueData: MPA; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 56; ValueData: OFR; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 57; ValueData: DTS; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 58; ValueData: WAX; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 59; ValueData: WVX; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 60; ValueData: WMX; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 65; ValueData: DIVX; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 66; ValueData: M4V; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 67; ValueData: PART; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 68; ValueData: VP6; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 69; ValueData: SWF; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 70; ValueData: TRP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 71; ValueData: FLC; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\FileAssList; ValueType: string; ValueName: 72; ValueData: FLI; Flags: uninsdeletevalue uninsdeletekeyifempty
; 
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun; Flags: uninsdeletekey
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell; Flags: uninsdeletekey
;-
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell\PlayCDAudio; Flags: uninsdeletekeyifempty; Tasks: auto\audiocd
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell\PlayCDAudio\Command; ValueType: string; ValueData: {app}\KMPlayer.exe %1 /cd; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiocd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayCDAudioOnArrival; ValueType: string; ValueName: KMPPlayCDAudioOnArrival; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiocd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: Action; ValueData:   CD; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiocd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: Provider; ValueData: The KMPlayer; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiocd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: InvokeProgID; ValueData: KMPlayer.AutoRun; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiocd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: InvokeVerb; ValueData: PlayCDAudio; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiocd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: DefaultIcon; ValueData: {app}\{#Appfile},0; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiocd
;-
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell\PlayMusicFiles; Flags: uninsdeletekeyifempty; Tasks: auto\audiofile
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell\PlayMusicFiles\Command; ValueType: string; ValueData: {app}\{#Appfile} %1; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayMusicFilesOnArrival; ValueType: string; ValueName: KMPPlayMusicFilesOnArrival; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: Action; ValueData:   CD; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: Provider; ValueData: The KMPlayer; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: InvokeProgID; ValueData: KMPlayer.AutoRun; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: InvokeVerb; ValueData: PlayMusicFiles; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: DefaultIcon; ValueData: {app}\{#Appfile},0; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\audiofile
;DVD-
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell\PlayDVDMovie; Flags: uninsdeletekeyifempty; Tasks: auto\videodvd
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell\PlayDVDMovie\Command; ValueType: string; ValueData: {app}\{#Appfile} %1 /dvd; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videodvd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayDVDMovieOnArrival; ValueType: string; ValueName: KMPPlayDVDMovieOnArrival; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videodvd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: Action; ValueData:  DVD; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videodvd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: Provider; ValueData: The KMPlayer; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videodvd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: InvokeProgID; ValueData: KMPlayer.AutoRun; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videodvd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: InvokeVerb; ValueData: PlayDVDMovie; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videodvd
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: DefaultIcon; ValueData: {app}\{#Appfile},0; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videodvd
;-
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayVideoFilesOnArrival; ValueType: string; ValueName: KMPPlayVideoFilesOnArrival; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videodvd
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell\PlayVideoFiles; Flags: uninsdeletekeyifempty; Tasks: auto\videofile
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.AutoRun\shell\PlayVideoFiles\Command; ValueType: string; ValueData: {app}\{#Appfile} %1; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: Action; ValueData:   CD; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: Provider; ValueData: The KMPlayer; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: InvokeProgID; ValueData: KMPlayer.AutoRun; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: InvokeVerb; ValueData: PlayVideoFiles; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videofile
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: DefaultIcon; ValueData: {app}\{#Appfile},0; Flags: uninsdeletevalue uninsdeletekeyifempty; Tasks: auto\videofile
;Video
Root: HKLM; SubKey: SOFTWARE\Classes\.3gp; ValueType: string; valuedata: KMPlayer.3gp; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('3gp'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.asf; ValueType: string; valuedata: KMPlayer.asf; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('asf'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.avi; ValueType: string; ValueData: KMPlayer.avi; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('avi'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.avi_neo_; ValueType: string; ValueData: KMPlayer.avi_neo_; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('avi_neo_'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.dat; ValueType: string; ValueData: KMPlayer.dat; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('dat'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.divx; ValueType: string; ValueData: KMPlayer.divx; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('divx'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.flv; ValueType: string; ValueData: KMPlayer.flv; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('flv'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.ifo; ValueType: string; ValueData: KMPlayer.ifo; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ifo'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.m1v; ValueType: string; ValueData: KMPlayer.m1v; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('m1v'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.m2v; ValueType: string; ValueData: KMPlayer.m2v; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('m2v'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.m4v; ValueType: string; ValueData: KMPlayer.m4v; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('m4v'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.mkv; ValueType: string; ValueData: KMPlayer.mkv; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mkv'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.mms; ValueType: string; ValueData: KMPlayer.mms; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mms'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.mov; ValueType: string; ValueData: KMPlayer.mov; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mov'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.mp4; ValueType: string; ValueData: KMPlayer.mp4; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mp4'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.mpe; ValueType: string; ValueData: KMPlayer.mpe; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mpe'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.mpeg; ValueType: string; ValueData: KMPlayer.mpeg; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mpeg'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.mpg; ValueType: string; ValueData: KMPlayer.mpg; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mpg'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.ogm; ValueType: string; ValueData: KMPlayer.ogm; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ogm'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.part; ValueType: string; ValueData: KMPlayer.part; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('part'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.tp; ValueType: string; ValueData: KMPlayer.tp; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('tp'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.ts; ValueType: string; ValueData: KMPlayer.ts; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ts'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.qt; ValueType: string; ValueData: KMPlayer.qt; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('qt'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.vob; ValueType: string; ValueData: KMPlayer.vob; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('vob'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.wmv; ValueType: string; ValueData: KMPlayer.wmv; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('wmv'); Tasks: assoc\video
Root: HKLM; SubKey: SOFTWARE\Classes\.aac; ValueType: string; ValueData: KMPlayer.aac; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('aac'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.ac3; ValueType: string; ValueData: KMPlayer.ac3; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ac3'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.ape; ValueType: string; ValueData: KMPlayer.ape; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ape'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.cda; ValueType: string; ValueData: KMPlayer.cda; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('cda'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.dts; ValueType: string; ValueData: KMPlayer.dts; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('dts'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.flac; ValueType: string; ValueData: KMPlayer.flac; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('flac'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.m4a; ValueType: string; ValueData: KMPlayer.m4a; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('m4a'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.mid; ValueType: string; ValueData: KMPlayer.mid; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mid'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.mka; ValueType: string; ValueData: KMPlayer.mka; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mka'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.mp2; ValueType: string; ValueData: KMPlayer.mp2; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mp2'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.mp3; ValueType: string; ValueData: KMPlayer.mp3; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mp3'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.mpa; ValueType: string; ValueData: KMPlayer.mpa; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mpa'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.mpc; ValueType: string; ValueData: KMPlayer.mpc; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('mpc'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.ofr; ValueType: string; ValueData: KMPlayer.ofr; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ofr'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.ogg; ValueType: string; ValueData: KMPlayer.ogg; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ogg'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.wav; ValueType: string; ValueData: KMPlayer.wav; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('wav'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.wma; ValueType: string; ValueData: KMPlayer.wma; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('wma'); Tasks: assoc\audio
Root: HKLM; SubKey: SOFTWARE\Classes\.ass; ValueType: string; ValueData: KMPlayer.ass; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ass'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.idx; ValueType: string; ValueData: KMPlayer.idx; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('idx'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.psb; ValueType: string; ValueData: KMPlayer.psb; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('psb'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.rt; ValueType: string; ValueData: KMPlayer.rt; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('rt'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.smi; ValueType: string; ValueData: KMPlayer.smi; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('smi'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.srt; ValueType: string; ValueData: KMPlayer.srt; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('srt'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.s2k; ValueType: string; ValueData: KMPlayer.s2k; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('s2k'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.ssa; ValueType: string; ValueData: KMPlayer.ssa; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ssa'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.sub; ValueType: string; ValueData: KMPlayer.sub; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('sub'); Tasks: assoc\subt
Root: HKLM; SubKey: SOFTWARE\Classes\.asx; ValueType: string; ValueData: KMPlayer.asx; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('asx'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.kpl; ValueType: string; ValueData: KMPlayer.kpl; Flags: uninsdeletekey
Root: HKLM; SubKey: SOFTWARE\Classes\.m3u; ValueType: string; ValueData: KMPlayer.m3u; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('m3u'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.pls; ValueType: string; ValueData: KMPlayer.pls; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('pls'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.wax; ValueType: string; ValueData: KMPlayer.wax; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('wax'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.wmx; ValueType: string; ValueData: KMPlayer.wmx; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('wmx'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.wvx; ValueType: string; ValueData: KMPlayer.wvx; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('wvx'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.ra; ValueType: string; ValueData: KMPlayer.ra; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ra'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.ram; ValueType: string; ValueData: KMPlayer.ram; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('ram'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.rm; ValueType: string; ValueData: KMPlayer.rm; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('rm'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.rmvb; ValueType: string; ValueData: KMPlayer.rmvb; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('rmvb'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.rmj; ValueType: string; ValueData: KMPlayer.rmj; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('rmj'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.rmm; ValueType: string; ValueData: KMPlayer.rmm; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('rmm'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.rms; ValueType: string; ValueData: KMPlayer.rms; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('rms'); Tasks: assoc\plst
Root: HKLM; SubKey: SOFTWARE\Classes\.flc; ValueType: string; ValueData: KMPlayer.flc; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('flc'); Tasks: assoc\other
Root: HKLM; SubKey: SOFTWARE\Classes\.fli; ValueType: string; ValueData: KMPlayer.fli; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('fli'); Tasks: assoc\other
Root: HKLM; SubKey: SOFTWARE\Classes\.ksf; ValueType: string; ValueData: KMPlayer.ksf; Flags: uninsdeletekey
Root: HKLM; SubKey: SOFTWARE\Classes\.trp; ValueType: string; ValueData: KMPlayer.trp; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('trp'); Tasks: assoc\other
Root: HKLM; SubKey: SOFTWARE\Classes\.vp6; ValueType: string; ValueData: KMPlayer.vp6; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('vp6'); Tasks: assoc\other
Root: HKLM; SubKey: SOFTWARE\Classes\.swf; ValueType: string; ValueData: KMPlayer.swf; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('swf'); Tasks: assoc\other
;.    
Root: HKLM; SubKey: SOFTWARE\Classes\Directory\shell\KMPlayer.Enqueue; valuetype: none; valuedata: ; Flags: UninsDeleteKey DontCreateKey
;Root: HKLM; SubKey: SOFTWARE\Classes\Directory\shell\KMPlayer.Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
;Root: HKLM; SubKey: SOFTWARE\Classes\Directory\shell\KMPlayer.Enqueue\Command; ValueType: string; ValueData: """{app}\{#Appfile}""/ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
;Root: HKLM; SubKey: SOFTWARE\Classes\Directory\shell\KMPlayer.Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
;.   
Root: HKLM; SubKey: SOFTWARE\Classes\Directory\shell\KMPlayer.Play; valuetype: none; valuedata: ; Flags: UninsDeleteKey DontCreateKey
;Root: HKLM; SubKey: SOFTWARE\Classes\Directory\shell\KMPlayer.Play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
;Root: HKLM; SubKey: SOFTWARE\Classes\Directory\shell\KMPlayer.Play\Command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
;Root: HKLM; SubKey: SOFTWARE\Classes\Directory\shell\KMPlayer.Play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
;
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",48"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.3gp\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf; ValueType: string; ValueData: KMP - Windows Media Movie; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",0"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asf\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi; ValueType: string; ValueData: KMP - Windows Movie File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",2"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_; ValueType: string; ValueData: KMP -   AVI; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",39"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.avi_neo_\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat; ValueType: string; ValueData: KMP - MPEG Movie File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",3"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dat\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx; ValueType: string; ValueData: KMP - DIVX  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",56"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.divx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",111"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flv\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo; ValueType: string; ValueData: KMP -   DVD; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",40"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ifo\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v; ValueType: string; ValueData: KMP -  MPEG V1; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",4"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m1v\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v; ValueType: string; ValueData: KMP -  MPEG V2; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",5"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m2v\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v; ValueType: string; ValueData: KMP - M4V  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",70"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4v\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv; ValueType: string; ValueData: KMP - Matroska File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",30"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mkv\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms; ValueType: string; ValueData: KMP -  Windows Media; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",7"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mms\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov; ValueType: string; ValueData: KMP - Apple QuickTime File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",8"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mov\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4; ValueType: string; ValueData: KMP - MP4 Audio/Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",43"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp4\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe; ValueType: string; ValueData: KMP -  MPEG; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",10"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpe\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg; ValueType: string; ValueData: KMP - MPEG Movie File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",11"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpeg\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg; ValueType: string; ValueData: KMP - MPEG Movie File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",12"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpg\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm; ValueType: string; ValueData: KMP - OGM Vorbis File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",29"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogm\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part; ValueType: string; ValueData: KMP - PART  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",86"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.part\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",97"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.tp\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",99"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ts\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt; ValueType: string; ValueData: KMP -  Apple QuickTime; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",13"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.qt\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob; ValueType: string; ValueData: KMP - DVD Movie File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",14"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vob\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv; ValueType: string; ValueData: KMP - Windows Media Movie File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",17"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmv\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

;Audio
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac; ValueType: string; ValueData: KMP - AAC Audio File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",42"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.aac\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",46"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ac3\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape; ValueType: string; ValueData: KMP - APE Audio File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",44"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ape\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda; ValueType: string; ValueData: KMP - CDA ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",54"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.cda\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",58"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.dts\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac; ValueType: string; ValueData: KMP - FLAC Audio File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",41"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flac\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",69"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m4a\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid; ValueType: string; ValueData: KMP - MIDI Music File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",6"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mid\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",72"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mka\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",77"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp2\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3; ValueType: string; ValueData: KMP - MPEG Layer3 Audio File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",9"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mp3\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",79"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpa\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc; ValueType: string; ValueData: KMP - MPC Audio File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",45"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.mpc\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",85"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ofr\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg; ValueType: string; ValueData: KMP - Ogg Vorbis File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",28"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ogg\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav; ValueType: string; ValueData: KMP - Windows Audio File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",15"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wav\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma; ValueType: string; ValueData: KMP - Windows Media Audio File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",16"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wma\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

;Subtitles
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass; ValueType: string; ValueData: KMP - ASS Subtitle File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",34"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ass\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx; ValueType: string; ValueData: KMP -   IDX; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",33"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.idx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb; ValueType: string; ValueData: KMP -   PSB; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",36"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.psb\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt; ValueType: string; ValueData: KMP -   RT; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",31"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rt\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi; ValueType: string; ValueData: KMP - SMIL Standard Subtitle File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",18"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.smi\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt; ValueType: string; ValueData: KMP - SRT Subtitle File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",37"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.srt\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k; ValueType: string; ValueData: KMP -   S2K; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",38"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.s2k\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa; ValueType: string; ValueData: KMP -   SSA; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",35"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ssa\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub; ValueType: string; ValueData: KMP -   SUB; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",32"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.sub\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

;Playlist
Root: HKLM; SubKey: SOFTWARE\Classes\.asx; ValueType: string; ValueData: KMPlayer.asx; Flags: uninsdeletevalue uninsdeletekeyifempty; BeforeInstall: BackupData('asx')
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx; ValueType: string; ValueData: KMP -    Windows Media; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",1"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.asx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl; ValueType: string; ValueData: KMPs Playlist File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\DefaultIcon; ValueType: string; ValueData: """{app}\{#Appfile}"",0"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.kpl\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u; ValueType: string; ValueData: KMP -    Winamp; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",20"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.m3u\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls; ValueType: string; ValueData: KMP -   Winamp; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",19"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.pls\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax; ValueType: string; ValueData: KMP - WAX  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",102"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wax\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx; ValueType: string; ValueData: KMP - WMX  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",105"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wmx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx; ValueType: string; ValueData: KMP - WVX  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",107"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.wvx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

;Real media
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra; ValueType: string; ValueData: KMP - RealMedia File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",21"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ra\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram; ValueType: string; ValueData: KMP - RealMedia File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",25"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ram\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm; ValueType: string; ValueData: KMP - RealMedia File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",22"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rm\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb; ValueType: string; ValueData: KMP - RealMedia File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",27"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmvb\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj; ValueType: string; ValueData: KMP - RealMedia File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",23"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmj\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm; ValueType: string; ValueData: KMP - RealMedia File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",26"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rmm\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms; ValueType: string; ValueData: KMP - RealMedia File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",24"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.rms\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

;Other
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin; ValueType: string; ValueData: KMP - BIN  CD; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",53"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.bin\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img; ValueType: string; ValueData: KMP - IMG  CD; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",63"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.img\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso; ValueType: string; ValueData: KMP - ISO  CD; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",64"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.iso\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc; ValueType: string; ValueData: KMP - FLC  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",59"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.flc\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli; ValueType: string; ValueData: KMP - FLI  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",60"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.fli\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf; ValueType: string; ValueData: KMPs Skin File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\DefaultIcon; ValueType: string; ValueData: """{app}\{#Appfile}"",0"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.ksf\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg; ValueType: string; ValueData: KMP - NRG  CD; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",84"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.nrg\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp; ValueType: string; ValueData: KMP - TRP  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",110"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.trp\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6; ValueType: string; ValueData: KMP - VP6  ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",101"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.vp6\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf; ValueType: string; ValueData: KMP -Video File; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",96"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\Enqueue\command; ValueType: string; ValueData: """{app}\{#Appfile}"" /ADD ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\open; Flags: uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\play; ValueType: string; ValueData:   KMP; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\play\command; ValueType: string; ValueData: """{app}\{#Appfile}"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Classes\KMPlayer.swf\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; Flags: uninsdeletevalue uninsdeletekeyifempty

[Languages]
Name: russian; MessagesFile: compiler:Languages\Russian.isl

[Messages]
BeveledLabel= Created by Cleric

[Code]
procedure BackupData(FileExt: String);
var
  OldValueData: string;
begin
  if RegValueExists(HKLM, 'SOFTWARE\Classes\' + '.' + FileExt, 'KMPBackup.bak') then
     begin
     end else
     begin
       if RegKeyExists(HKLM, 'SOFTWARE\Classes\' + '.' + FileExt) then
          begin
            RegQueryStringValue(HKLM, 'SOFTWARE\Classes\' + '.' + FileExt, '', OldValueData);
            RegWriteStringValue(HKLM, 'SOFTWARE\Classes\' + '.' + FileExt, 'KMPBackup.bak', OldValueData);
          end;
     end;
end;

procedure RestoreData(FileExt: String);
var
  OldValueData: string;
begin
  if RegValueExists(HKLM, 'SOFTWARE\Classes\' + '.' + FileExt, 'KMPBackup.bak') then
    begin
      RegQueryStringValue(HKLM, 'SOFTWARE\Classes\' + '.' + FileExt, 'KMPBackup.bak', OldValueData);
      RegWriteStringValue(HKLM, 'SOFTWARE\Classes\' + '.' + FileExt, '', OldValueData);
      RegDeleteValue(HKLM, 'SOFTWARE\Classes\' + '.' + FileExt, 'KMPBackup.bak');
    end;
end;

procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
begin
  if CurUninstallStep = usPostUninstall then
    begin
      RestoreData('3gp');
      RestoreData('asf');
      RestoreData('avi');
      RestoreData('avi_NEO_');
      RestoreData('dat');
	  RestoreData('dvx');
      RestoreData('flv');
	  RestoreData('ifo');
	  RestoreData('m1v');
	  RestoreData('m2v');
	  RestoreData('m4v');
      RestoreData('mkv');
	  RestoreData('mms');
      RestoreData('mov');
      RestoreData('mp4');
      RestoreData('mpeg');
      RestoreData('mpg');
	  RestoreData('mpe');
	  RestoreData('ogm');
      RestoreData('part');
	  RestoreData('tp');
	  RestoreData('ts');
	  RestoreData('qt');
      RestoreData('vob');
      RestoreData('wmv');
      RestoreData('aac');
      RestoreData('ac3');
      RestoreData('ape');
	  RestoreData('cda');
      RestoreData('dts');
      RestoreData('flac');
      RestoreData('m4a');
      RestoreData('mid');
      RestoreData('mka');
      RestoreData('mp2');
      RestoreData('mp3');
      RestoreData('mpa');
      RestoreData('mpc');
      RestoreData('ofr');
      RestoreData('ogg');
      RestoreData('wav');
      RestoreData('wma');
      RestoreData('ass');
	  RestoreData('idx');
	  RestoreData('psb');
	  RestoreData('rt');
	  RestoreData('smi');
      RestoreData('srt');
      RestoreData('s2k');
	  RestoreData('ssa');
	  RestoreData('sub');
	  RestoreData('asx');
	  RestoreData('m3u');
	  RestoreData('pls');
	  RestoreData('wax');
	  RestoreData('wmx');
	  RestoreData('wvx');
	  RestoreData('ra');
	  RestoreData('ram');
	  RestoreData('rm');
	  RestoreData('rmvb');
      RestoreData('rmj');
      RestoreData('rmm');
      RestoreData('rms');
	  RestoreData('flc');
      RestoreData('fli');
	  RestoreData('trp');
	  RestoreData('vp6');
	  RestoreData('swf');
	  RestoreData('iso');
	  RestoreData('img');
	  RestoreData('bin');
	  RestoreData('nrg');
	  end;
end;

[UninstallDelete]
Name: {app}\*; Type: filesandordirs
