//const
//	FileTypes		= '';
//	BackupName		= '';
//	AppClassMask		= '';
//	HKLM_Class		= 1;
//	HKCU_Class		= 1;
//	FileExt			= 1;
//	AppCapsRegPath		= '';
//	AddOpenWith		= 1;
//	BackupExtsTask		= '';

type
	RegKeys = record
		Root		: Longint;
		Key		: String;
		Val		: String;
		Used		: Longint;
		JustRemoveKey	: Boolean;
	end;

	CleanupKeys	= record
		Root		: Longint;
		Key		: String;
		KeyMode		: Longint;
	end;

function StrToArr (Str, Splitter : String) : Array of String;
var
	aResult	: Array Of String;
	cPos	: Longint;
	cStr	: String;

begin
	while Length (Str) > 0 do
	begin

		cPos := Pos (Splitter, Str);

		if cPos <> 0 then
		begin
			cStr := Copy (Str, 1, cPos - 1);
			Delete (Str, 1, cPos);
		end
		else
		begin
			cStr := Copy (Str, 1, Length (Str));
			Str:= '';
		end;

		if Length (cStr) > 0 then
		begin
			SetArrayLength (aResult, GetArrayLength (aResult) + 1);
			aResult[GetArrayLength (aResult) - 1] :=cStr;
		end;
	end;

	result := aResult
end;


function GetClassKeys (Ext : String) : Array of RegKeys;
var
	RegKey : Array [0..2] of RegKeys;

begin

	RegKey[0].Root := HKLM;	RegKey[0].Key := 'Software\Classes\.' + Ext; RegKey[0].Val := ''; 													RegKey[0].Used := HKLM_Class;
	RegKey[1].Root := HKCU;	RegKey[1].Key := 'Software\Classes\.' + Ext; RegKey[1].Val := '';													RegKey[1].Used := HKCU_Class;
	RegKey[2].Root := HKCU;	RegKey[2].Key := 'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.' + Ext; RegKey[2].Val := 'ProgID';	RegKey[2].Used := FileExt;

	if GetWindowsVersion shr 24 >= 6 then
	begin
		RegKey[2].Key			:= RegKey[2].Key + '\UserChoice';
		RegKey[2].JustRemoveKey	:= True;
	end;

	result := RegKey;
end;


function GetCleanupKeys (Ext : String) : Array of CleanupKeys;
var
	RegKey : Array [0..2] of CleanupKeys;

begin

	RegKey[0].Root := HKLM;	RegKey[0].Key := 'Software\Classes\.' + Ext;									RegKey[0].KeyMode := 1;
	RegKey[1].Root := HKCU;	RegKey[1].Key := 'Software\Classes\.' + Ext;									RegKey[1].KeyMode := 1;
	RegKey[2].Root := HKCU;	RegKey[2].Key := 'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.' + Ext;				RegKey[2].KeyMode := 0;

	result := RegKey;
end;


function AppExist (AppName : String) : Boolean;
begin
	if (AppName <> '') and (RegKeyExists (HKCU, 'Software\Classes\Applications\'+AppName) or RegKeyExists (HKLM, 'Software\Classes\Applications\'+AppName)) then
		result := True;
end;


function ClassExist (ClassName : String) : Boolean;
begin
	if (ClassName <> '') and (RegKeyExists (HKCU, 'Software\Classes\'+ClassName) or RegKeyExists (HKLM, 'Software\Classes\'+ClassName)) then
		result := True;
end;


procedure BackupExt (Ext : String);
var
	i			: Longint;
	Keys			: Array of RegKeys;
	AppID, cAppID, cBackup	: String;

begin

	Keys	:= GetClassKeys (Ext);
	AppID	:= AppClassMask;

	StringChangeEx	(AppID, '%ext%', Ext, True);

	for i := 0 to GetArrayLength (Keys) - 1 do
	begin

		if Keys[i].JustRemoveKey then
			RegDeleteKeyIncludingSubkeys (Keys[i].Root, Keys[i].Key)

		else if RegQueryStringValue (Keys[i].Root, Keys[i].Key, Keys[i].Val, cAppID) then
		begin

			if ClassExist (cAppID) and (CompareText (cAppID, AppID) <> 0) then
				RegWriteStringValue (Keys[i].Root, Keys[i].Key, BackupName, cAppID)
			else
				if RegQueryStringValue (Keys[i].Root, Keys[i].Key, BackupName, cBackup) then
					if not ClassExist (cBackup) or (CompareText (cBackup, AppID) = 0) then
						RegDeleteValue (Keys[i].Root, Keys[i].Key, BackupName);

			if not (Keys[i].Used = 1) then
			begin
				RegDeleteValue		(Keys[i].Root, Keys[i].Key, Keys[i].Val);
				RegDeleteKeyIfEmpty	(Keys[i].Root, Keys[i].Key);
			end;
		end;
	end;

	if not (GetWindowsVersion shr 24 >= 6) then
		RegDeleteValue (HKCU, 'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.' + Ext, 'Application');

	if Length (AppCapsRegPath) > 0 then
		RegWriteStringValue (HKLM, AddBackslash (AppCapsRegPath) + 'FileAssociations', '.' + Ext, AppID);

end;


procedure RestoreExt (Ext : String);
var
	i			: Longint;
	Keys			: Array of RegKeys;
	AppID, cAppID, cBackup	: String;

begin
	Keys	:= GetClassKeys (Ext);
	AppID	:= AppClassMask;

	StringChangeEx	(AppID, '%ext%', Ext, True);

	for i := 0 to GetArrayLength (Keys) - 1 do
	begin

		if (RegQueryStringValue (Keys[i].Root, Keys[i].Key, Keys[i].Val, cAppID) and ((cAppID = AppID) or ((Length (cAppID) = 0) and (Keys[i].Used = 0))) ) then
		begin
			if Keys[i].JustRemoveKey then
				RegDeleteKeyIncludingSubkeys (Keys[i].Root, Keys[i].Key)

			else if RegQueryStringValue (Keys[i].Root, Keys[i].Key, BackupName, cBackup) and ClassExist (cBackup) and (CompareText (cBackup, AppID) <> 0) then
				RegWriteStringValue (Keys[i].Root, Keys[i].Key, Keys[i].Val, cBackup)
			else
				RegDeleteValue (Keys[i].Root, Keys[i].Key, Keys[i].Val);
		end;

		RegDeleteValue (Keys[i].Root, Keys[i].Key, BackupName);
	end;
end;


procedure CleanupExt (Ext : String);
var
	i,k	: Longint;
	Keys	: Array of CleanupKeys;
	List	: Array of String;
	Str	: String;

begin

	Keys	:= GetCleanupKeys (Ext);

	for i := 0 to GetArrayLength (Keys) - 1 do
	begin

		if RegGetValueNames (Keys[i].Root, Keys[i].Key + '\OpenWithProgids', List) then
			for k := 0 to GetArrayLength (List) - 1 do
				if not ClassExist (List[k]) then
					RegDeleteValue (Keys[i].Root, Keys[i].Key + '\OpenWithProgids', List[k]);

		if not (Keys[i].KeyMode = 1) then
		begin
			RegDeleteValue (Keys[i].Root, Keys[i].Key + '\OpenWithList', 'MRUList');

			if RegGetValueNames (Keys[i].Root, Keys[i].Key + '\OpenWithList', List) then
			begin
				for k := 0 to GetArrayLength (List) - 1 do
				begin
					if not (RegQueryStringValue (Keys[i].Root, Keys[i].Key + '\OpenWithList', List[k], Str) and AppExist(Str)) then
						RegDeleteValue (Keys[i].Root, Keys[i].Key + '\OpenWithList', List[k])
					else
					begin
						if not RegQueryStringValue (Keys[i].Root, Keys[i].Key + '\OpenWithList', 'MRUList', Str) then
							Str := '';

						RegWriteStringValue (Keys[i].Root, Keys[i].Key + '\OpenWithList', 'MRUList', Str + List[k]);
					end;
				end;
			end;
		end
		else
			if RegGetSubkeyNames (Keys[i].Root, Keys[i].Key + '\OpenWithList', List) then
				for k := 0 to GetArrayLength (List) - 1 do
					if not AppExist(List[k]) then
						RegDeleteKeyIncludingSubkeys (Keys[i].Root, Keys[i].Key + '\OpenWithList\' + List[k]);

		if not (RegQueryStringValue (Keys[i].Root, Keys[i].Key, 'Application', Str) and AppExist(Str)) then
			RegDeleteValue	(Keys[i].Root, Keys[i].Key, 'Application');

		RegDeleteKeyIfEmpty 	(Keys[i].Root, Keys[i].Key + '\OpenWithProgids');
		RegDeleteKeyIfEmpty	(Keys[i].Root, Keys[i].Key + '\OpenWithList');
		RegDeleteKeyIfEmpty	(Keys[i].Root, Keys[i].Key + '\UserChoice');
		RegDeleteKeyIfEmpty	(Keys[i].Root, Keys[i].Key + '\Shell');
		RegDeleteKeyIfEmpty	(Keys[i].Root, Keys[i].Key + '\ShellEx');

		RegDeleteKeyIfEmpty	(Keys[i].Root, Keys[i].Key);

	end;
end;


procedure ManageOpenWith (Ext : String; IsDelete : Longint);

var
	i	: Longint;
	Keys	: Array of CleanupKeys;
	AppID	: String;

begin

	Keys	:= GetCleanupKeys (Ext);
	AppID	:= AppClassMask;

	StringChangeEx	(AppID, '%ext%', Ext, True);

	if (IsDelete = 0) and ClassExist (AppID) then
		RegWriteBinaryValue (Keys[0].Root, Keys[0].Key + '\OpenWithProgids', AppID, '')
	else
		for i := 0 to GetArrayLength (Keys) - 1 do
			RegDeleteValue	(Keys[i].Root, Keys[i].Key + '\OpenWithProgids', AppID);

end;



procedure CurStepChanged (CurStep: TSetupStep);

var
	i 	: Longint;
	Ext	: Array of String;

begin

	if (CurStep = ssInstall) and (Length (BackupExtsTask) > 0) and IsTaskSelected (BackupExtsTask) then
	begin
		Ext := StrToArr (FileTypes, '|');

		for i := 0 to GetArrayLength (Ext) - 1 do
			BackupExt (Ext[i]);
	end;

	if (CurStep = ssPostInstall) and (AddOpenWith = 1) then
	begin
		Ext := StrToArr (FileTypes, '|');

		for i := 0 to GetArrayLength (Ext) - 1 do
			ManageOpenWith	(Ext[i], 0);
	end;
end;


procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
var
	i 	: Longint;
	Ext	: Array of String;

begin
	if CurUninstallStep = usPostUninstall then
	begin
		Ext := StrToArr (FileTypes, '|');

		for i := 0 to GetArrayLength (Ext) - 1 do
		begin
			ManageOpenWith	(Ext[i], 1);
			RestoreExt		(Ext[i]);
			CleanupExt		(Ext[i]);
		end;
	end;
end;