;    Tasks? (!!!        (ASCII > 127)     ,         [Tasks]\Name)
#define AddSkinsTasks	1
#define SkinsMask	AddBackslash(SourcePath) + "{app}\Skins\*.ksf"

; Pre-processor AddSkin part
#define FindHandle
#define FindResult
#define FileName

#define TaskDesc
#define TaskName
#define TaskDropSym	" !#$%&'()+,-.;=@[]^`{}~"

#sub GetSkinVars
	#define i

	#expr FileName = FindGetFileName	(FindHandle)
	#expr TaskDesc = Copy			(FileName, 0, RPos (".", FileName) - 1)
	#expr TaskName = Lowercase		(TaskDesc)

	#for {i=1; i <= Len (TaskDropSym); i++} TaskName = StringChange (TaskName, Copy (TaskDropSym, i, 1), "_")

	#expr TaskName = StringChange		(TaskName, "__", "_")
#endsub

#sub SkinTask
	#expr GetSkinVars
	Name: skins\{#TaskName}; Description: {#TaskDesc}; Flags: unchecked exclusive
#endsub

#sub SkinAddReg
	#expr GetSkinVars
	Root: HKCU; Subkey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: string; ValueName: SkinFolder; ValueData: {#FileName}; Tasks: skins\{#TaskName}
#endsub

[Setup]
#define AppExe		  "{app}\KMPlayer.exe"
;OutputDir		={#SourcePath}\..\..\_Make\Soft\Multimedia\Players\KMPlayer

#define AppVer		GetFileVersion(AddBackslash(SourcePath) + AppExe)
#define AppName		"KMPlayer"
#define AppPub		"Pandora.TV"
#define AppURL		"http://www.kmplayer.com"

AppName			= {#AppName}
AppPublisher		= {#AppPub}
AppPublisherURL		= {#AppURL}
UninstallDisplayIcon	= {#AppExe}

DefaultDirName		= {pf}\{#AppName}
DefaultGroupName	= {#AppName}
AllowNoIcons		= yes

MinVersion		= 0,5.0

ChangesAssociations	= true

ShowLanguageDialog	= auto
DisableStartupPrompt	= yes
DisableReadyPage	= yes
DisableReadyMemo	= yes

AppVersion		= {#AppVer}
VersionInfoVersion	= {#AppVer}

OutputBaseFilename	= kmp
SetupIconFile		= Setup.ico
WizardImageFile		= WizardImage.bmp
WizardSmallImageFile	= WizardSmallImage.bmp
SolidCompression	= true
Compression		= lzma2/ultra

[Languages]
Name: ru; MessagesFile: compiler:Languages\Russian.isl

[Tasks]
Name: programs_icon; Description:    \; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: programs_cat_icon; Description:    \\{code:GetProgsCatName}; GroupDescription: {cm:AdditionalIcons}; Check: WizardNoIcons; Flags: unchecked
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: quicklaunchicon; Description: {cm:CreateQuickLaunchIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked

Name: reset_settings; Description:   ; GroupDescription:  :
Name: reset_codec_settings; Description:    ; GroupDescription:  :

Name: autoplay; Description:  CD/DVD; GroupDescription: :
Name: autoplay\audiocd; Description: -CD; Flags: unchecked
Name: autoplay\videodvd; Description: -DVD
Name: autoplay\audiofile; Description: -; Flags: unchecked
Name: autoplay\videofile; Description: -

Name: filetypes; Description:  ; GroupDescription: :
Name: filetypes\video; Description: 
Name: filetypes\audio; Description: ; Flags: unchecked
Name: filetypes\sub; Description: 
Name: filetypes\pls; Description: ; Flags: unchecked

#if FileExists (SkinsMask) & (AddSkinsTasks == 1)
	Name: skins; Description:  ; GroupDescription:  :
	Name: skins\build_in; Description: ; Flags: exclusive
	#for {FindHandle = FindResult = FindFirst(SkinsMask, 0); FindResult; FindResult = FindNext(FindHandle)} SkinTask
#endif

Name: tweaks; Description:  ; GroupDescription:  :

Name: tweaks\auto_load_aud; Description:   -
Name: tweaks\auto_load_sub; Description:   
Name: tweaks\save_playpos; Description:   ; Flags: unchecked
Name: tweaks\no_videoproc; Description:   KMP
Name: tweaks\large_scr; Description:     ; Flags: unchecked
Name: tweaks\seek_wheel; Description:   

Name: tweaks\persist; Description: C 
Name: tweaks\persist\auto; Description: ; Flags: exclusive unchecked
Name: tweaks\persist\source; Description: ; Flags: exclusive unchecked
Name: tweaks\persist\screen; Description: ; Flags: exclusive

Name: tweaks\renderer; Description:  
Name: tweaks\renderer\overlay; Description: ; Flags: exclusive unchecked
Name: tweaks\renderer\vmr7w; Description: VMR7 Windowed; Flags: exclusive unchecked
Name: tweaks\renderer\vmr9w; Description: VMR9 Windowed; Flags: exclusive unchecked
Name: tweaks\renderer\vmr7; Description: VMR7 Renderless; Flags: exclusive unchecked
Name: tweaks\renderer\vmr9; Description: VMR9 Renderless; Flags: exclusive
Name: tweaks\renderer\evr; Description: EVR [ ]; Flags: exclusive unchecked
Name: tweaks\renderer\evr_ca; Description: EVR (C/A) [ ]; Flags: exclusive unchecked

Name: tweaks\close_esc; Description:   ESC
Name: tweaks\top_most; Description:   
Name: tweaks\use_tray; Description:    ; Flags: unchecked


[Icons]
Name: {group}\{#AppName}; Filename: {#AppExe}; WorkingDir: {app}
Name: {group}\{#AppName} Setup Wizard; Filename: {app}\KMPSetup.exe; WorkingDir: {app}; Flags: createonlyiffileexists
Name: {group}\{cm:UninstallProgram,{#AppName}};	 Filename: {uninstallexe}; IconFilename: {sys}\shell32.dll; IconIndex: 162

Name: {code:GetProgsDir}\{#AppName}; Filename: {#AppExe}; WorkingDir: {app}; Tasks: programs_icon
Name: {group}\{#AppName}; Filename: {#AppExe}; WorkingDir: {app}; Tasks: programs_cat_icon
Name: {userdesktop}\{#AppName}; Filename: {#AppExe}; WorkingDir: {app}; Tasks: desktopicon
Name: {userappdata}\Microsoft\Internet Explorer\Quick Launch\{#AppName}; Filename: {#AppExe}; WorkingDir: {app}; Tasks: quicklaunchicon

[Dirs]
Name: {app}\Language; Flags: uninsalwaysuninstall
Name: {app}\Logo; Flags: uninsalwaysuninstall
Name: {app}\Plugins; Flags: uninsalwaysuninstall
Name: {app}\Shader; Flags: uninsalwaysuninstall
Name: {app}\Skins; Flags: uninsalwaysuninstall
Name: {app}; Flags: uninsalwaysuninstall

[Files]
Source: {app}\*.*; DestDir: {app}; Flags: ignoreversion overwritereadonly uninsremovereadonly restartreplace uninsrestartdelete recursesubdirs createallsubdirs sortfilesbyname

[Registry]
;   
Root: HKCU; SubKey: Software\KMPlayer; Flags: uninsdeletekey deletekey; Tasks: reset_settings

;   
Root: HKCU; Subkey: Software\Microsoft\Multimedia\ActiveMovie\Filter Cache; Flags: deletekey; Tasks: reset_codec_settings
Root: HKCU; Subkey: Software\AC3filter; Flags: deletekey; Tasks: reset_codec_settings
Root: HKCU; Subkey: Software\Gabest\Filters; Flags: deletekey; Tasks: reset_codec_settings

;  

;  
#if FileExists (SkinsMask) && (AddSkinsTasks = 1)
	Root: HKCU; Subkey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: string; ValueName: SkinFolder; ValueData: ( ); Tasks: skins\build_in
	#for {FindHandle = FindResult = FindFirst(SkinsMask, 0); FindResult; FindResult = FindNext(FindHandle)} SkinAddReg
#endif

;  
Root: HKCU; Subkey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: string; ValueName: ColorThemeName; Check: IsTaskSelected ('skins')
Root: HKCU; Subkey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: string; ValueName: LanguageIniName; ValueData: Russian.ini; Languages: ru

;  - (     CPU)
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: PlayPriorityClass; ValueData: 2

;   (   )

; +  
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPG2; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPG2MAD; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPG3_1; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPG3MAD; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecA52; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecA52DLL; ValueData: 1; Tasks: reset_settings

Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPEG2; ValueData: 1; Tasks: reset_settings; Check: not IsTaskSelected ('tweaks\renderer\evr') or IsTaskSelected ('tweaks\renderer\evr_ca')
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPEG2DLL; ValueData: 1; Tasks: reset_settings

; +  
;Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: Halli_TS; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ASFFileReaderMode; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ASFURLReaderMode; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtMKVSplitter; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: MPEG1SeekFix; ValueData: 2; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: MPEG2SeekFix; ValueData: 2; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtTPSplitter; ValueData: 1; Tasks: reset_settings

; + MPC HC Video Decoder ( )
#ifexist AddBackslash(SourcePath) + "{app}\mpcvideodec.ax"
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\ExtFilterList\00000; ValueType: dword; ValueName: Disabled; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\ExtFilterList\00000; ValueType: dword; ValueName: ftype; ValueData: 1; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\ExtFilterList\00000; ValueType: dword; ValueName: LoadType; ValueData: 1; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\ExtFilterList\00000; ValueType: dword; ValueName: Merit; ValueData: 7401474; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\ExtFilterList\00000; ValueType: string; ValueName: name; ValueData: MPC - Video decoder; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\ExtFilterList\00000; ValueType: string; ValueName: clsid; ValueData: {{008BAC12-FBAF-497B-9670-BC6F6FBAE2C4}; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\ExtFilterList\00000; ValueType: string; ValueName: path; ValueData: {app}\mpcvideodec.ax; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecXVID; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecDivX3; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecDivX4; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecDivX5; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecAVC1; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecH264; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: sCodecWVC1; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtXvidVideo; ValueData: 2; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtDivX3Video; ValueData: 2; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtDivX4Video; ValueData: 2; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtDivX5Video; ValueData: 2; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtAVC1Video; ValueData: 2; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtH264Video; ValueData: 2; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtWVC1Video; ValueData: 2; Tasks: reset_settings

	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 5; Tasks: reset_settings
#endif

; + Gabest Audio Decoder ( )
#ifexist AddBackslash(SourcePath) + "{app}\mpadecfilter.ax"
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPG2; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPG3_1; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecA52; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecOggVorbis; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecAAC; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecDTS; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPEG2LPCM; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecMP3Audio; ValueData: 1; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecMPEG1Audio; ValueData: 2; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecMPEG2Audio; ValueData: 1; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecAC3; ValueData: 1; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecDTS; ValueData: 1; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecLPCM; ValueData: 1; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtAACSound; ValueData: 1; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtVorbisSound; ValueData: 1; Tasks: reset_settings
#endif

; + AC3Filter ( )
#ifexist AddBackslash(SourcePath) + "{app}\ac3filter.ax"
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPG2; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecA52; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecDTS; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CodecMPEG2LPCM; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecMPEG1Audio; ValueData: 1; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecMPEG2Audio; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecAC3; ValueData: 0; Tasks: reset_settings
	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecDTS; ValueData: 0; Tasks: reset_settings
;	Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ExtCodecLPCM; ValueData: 0; Tasks: reset_settings
#endif

; *   FilterGraph,  SmartConnect
;Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UseAdvFilterGraph; ValueData: 0; Tasks: reset_settings
;Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UseSmartConnect; ValueData: 1; Tasks: reset_settings

; +  
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AudioUseAutoGain_2; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AudioAutoGainType; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AudioAutoGain; ValueData: 60; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AudioAGSmooth; ValueData: 10; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AudioTransType; ValueData: 1; Tasks: reset_settings

; -   
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: CaptionVisible; ValueData: 0; Tasks: reset_settings

; +  
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: Play1stSec; ValueData: 15; Tasks: reset_settings

; +   
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: OpenWithFileMode; ValueData: 2; Tasks: reset_settings

; +   ,     
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AudioPlayNextMode; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoPlayNextMode; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AudioCompOperation; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoCompOperation; ValueData: 1; Tasks: reset_settings

; -     
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: EmptyPlayList; ValueData: 0; Tasks: reset_settings

; +  / 
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: StartCenterSize; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: StartDesktopMode; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: StartWindowState; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: PlayScreenSize; ValueData: 4; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: RestoreSize; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: RestorePos; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: RestoreAudioPos; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: RestoreNormal; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: RestoreFullState; ValueData: 0; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: RestoreTrayVideo; ValueData: 0; Tasks: reset_settings

; +   
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: MinToTray; ValueData: 1; Tasks: reset_settings

; +  
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AdvancedMenu; ValueData: 1; Tasks: reset_settings

; +   / 
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VolumeLevel; ValueData: 100; Tasks: reset_settings
Root: HKCU; Subkey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AudioBalance; ValueData: 50; Tasks: reset_settings

; +      (SHIFT + DEL)
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: DeleteWithSubtitle; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: DeleteRecycleBin; ValueData: 1; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AutoPlayDeleteFile; ValueData: 1; Tasks: reset_settings

; +   512x384
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: WidthLen; ValueData: 512; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: HeightLen; ValueData: 384; Tasks: reset_settings
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: PLHeightLen; ValueData: 384; Tasks: reset_settings

;   ( )

; +  
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AutoExternalAudio; ValueData: 0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AutoLoadingCaption; ValueData: 0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AutoCalPersist; ValueData: 0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ForceUseTrayIcon; ValueData: 0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: LargeScreenRatio; ValueData: 0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: SaveFilePosition; ValueData: 0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: SaveFilePositionWithAudio; ValueData: 0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: TopMost; ValueData: 2
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: TopMostAudio; ValueData: 2
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 5; Check: IsTaskSelected ('tweaks\renderer')

; + 
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AutoExternalAudio; ValueData: 1; Tasks: tweaks\auto_load_aud
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AutoLoadingCaption; ValueData: 1; Tasks: tweaks\auto_load_sub
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: AutoCalPersist; ValueData: 1; Tasks: tweaks\persist\auto
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: PersistScreen; ValueData: 1; Tasks: tweaks\persist\source
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: PersistScreen; ValueData: 2; Tasks: tweaks\persist\screen
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: ForceUseTrayIcon; ValueData: 1; Tasks: tweaks\use_tray
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: LargeScreenRatio; ValueData: 1; Tasks: tweaks\large_scr
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: SaveFilePosition; ValueData: 1; Tasks: tweaks\save_playpos
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: SaveFilePositionWithAudio; ValueData: 1; Tasks: tweaks\save_playpos
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: TopMost; ValueData: 1; Tasks: tweaks\top_most
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: TopMostAudio; ValueData: 0; Tasks: tweaks\top_most
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 1; Tasks: tweaks\renderer\overlay; OnlyBelowVersion: 0, 6.0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 2; Tasks: tweaks\renderer\vmr7w
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 3; Tasks: tweaks\renderer\vmr9w
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 4; Tasks: tweaks\renderer\vmr7
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 5; Tasks: tweaks\renderer\vmr9
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 15; Tasks: tweaks\renderer\evr; Check: FileExists (ExpandConstant ('{sys}\evr.dll'))
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoRenderDevice; ValueData: 16; Tasks: tweaks\renderer\evr_ca; Check: FileExists (ExpandConstant ('{sys}\evr.dll'))
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: VideoTransType; ValueData: 2; Tasks: tweaks\no_videoproc
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey2; ValueData: 10; Tasks: tweaks\close_esc
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey7; ValueData: 5; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey8; ValueData: 6; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey9; ValueData: 7; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey10; ValueData: 8; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey11; ValueData: $D; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey12; ValueData: $C; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey13; ValueData: 0; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey14; ValueData: 0; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: UserDefineMouseKey15; ValueData: 0; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: InverseWheel1; ValueData: 1; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: InverseWheel2; ValueData: 1; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: InverseWheel3; ValueData: 1; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: InverseWheel4; ValueData: 1; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: InverseWheel5; ValueData: 0; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: InverseWheel6; ValueData: 0; Tasks: tweaks\seek_wheel
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0\OptionArea; ValueType: dword; ValueName: InverseWheel7; ValueData: 0; Tasks: tweaks\seek_wheel

;  
Root: HKCU; Subkey: Software\Classes\Applications\kmplayer.exe; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Classes\Applications\kmplayer.exe; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Classes\Applications\kmplayer.exe\shell\open\command; ValueType: String; ValueData: """{#AppExe}"" ""%1"""

Root: HKLM; SubKey: Software\Classes\CLSID\{{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}; ValueType: string; ValueData: KMPlayer; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\CLSID\{{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}\LocalServer32; ValueType: string; ValueData: {code:GetShortName|{#AppExe}}
Root: HKLM; SubKey: Software\Classes\CLSID\{{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}\ProgID; ValueType: string; ValueData: KMPlayer.TKMPDropTarget2

Root: HKLM; SubKey: Software\Classes\CLSID\{{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}; ValueType: string; ValueData: KMPlayer; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\CLSID\{{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}\LocalServer32; ValueType: string; ValueData: {code:GetShortName|{#AppExe}}
Root: HKLM; SubKey: Software\Classes\CLSID\{{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}\ProgID; ValueType: string; ValueData: KMPlayer.TKMPDropTarget

Root: HKLM; SubKey: Software\Classes\KMPlayer.TKMPDropTarget; ValueType: string; ValueData: KMPlayer; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.TKMPDropTarget\Clsid; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.TKMPDropTarget2; ValueType: string; ValueData: KMPlayer; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.TKMPDropTarget2\Clsid; ValueType: string; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp; ValueType: string; ValueData: KMP - 3GP ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",48"
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.3gp\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.aac; ValueType: string; ValueData: KMP -  AAC; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",42"
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.aac\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3; ValueType: string; ValueData: KMP -  AC3; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",46"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ac3\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ape; ValueType: string; ValueData: KMP -  APE; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",44"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ape\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.asf; ValueType: string; ValueData: KMP -  Windows Media; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",0"
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.asf\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ass; ValueType: string; ValueData: KMP -   ASS; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",34"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ass\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.asx; ValueType: string; ValueData: KMP -    Windows Media; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",1"
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.asx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.avi; ValueType: string; ValueData: KMP -   Windows; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",2"
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_; ValueType: string; ValueData: KMP -   AVI; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",39"
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.avi_neo_\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.bin; ValueType: string; ValueData: KMP - BIN  CD; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",53"
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.bin\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.cda; ValueType: string; ValueData: KMP - CDA ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",54"
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.cda\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.dat; ValueType: string; ValueData: KMP -  MPEG; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",3"
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.dat\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.divx; ValueType: string; ValueData: KMP - DIVX  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",56"
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.divx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.dts; ValueType: string; ValueData: KMP - DTS ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",58"
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.dts\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.flac; ValueType: string; ValueData: KMP -  FLAC; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",41"
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flac\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.flc; ValueType: string; ValueData: KMP - FLC  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",59"
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flc\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.fli; ValueType: string; ValueData: KMP - FLI  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",60"
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.fli\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.flv; ValueType: string; ValueData: KMP - FLV ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",111"
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.flv\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.idx; ValueType: string; ValueData: KMP -   IDX; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",33"
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.idx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo; ValueType: string; ValueData: KMP -   DVD; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",40"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ifo\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.img; ValueType: string; ValueData: KMP - IMG  CD; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",63"
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.img\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.iso; ValueType: string; ValueData: KMP - ISO  CD; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",64"
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.iso\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl; ValueType: string; ValueData: KMP's Playlist File; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\DefaultIcon; ValueType: string; ValueData: """{#AppExe}"",0"
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.kpl\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf; ValueType: string; ValueData: KMP's Skin File; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\DefaultIcon; ValueType: string; ValueData: """{#AppExe}"",0"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ksf\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v; ValueType: string; ValueData: KMP -  MPEG V1; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",4"
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m1v\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v; ValueType: string; ValueData: KMP -  MPEG V2; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",5"
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m2v\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u; ValueType: string; ValueData: KMP -    Winamp; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",20"
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m3u\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a; ValueType: string; ValueData: KMP - M4A ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",69"
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4a\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v; ValueType: string; ValueData: KMP - M4V  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",70"
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.m4v\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mid; ValueType: string; ValueData: KMP -  MIDI; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",6"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mid\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mka; ValueType: string; ValueData: KMP - MKA ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",72"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mka\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv; ValueType: string; ValueData: KMP -  Matroska; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",30"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mkv\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mms; ValueType: string; ValueData: KMP -  Windows Media; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",7"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mms\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mov; ValueType: string; ValueData: KMP -  Apple QuickTime; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",8"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mov\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2; ValueType: string; ValueData: KMP - MP2 ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",77"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp2\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3; ValueType: string; ValueData: KMP -  MPEG Layer3; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",9"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp3\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4; ValueType: string; ValueData: KMP - / MP4; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",43"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mp4\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa; ValueType: string; ValueData: KMP - MPA ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",79"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpa\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc; ValueType: string; ValueData: KMP -  MPC; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",45"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpc\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe; ValueType: string; ValueData: KMP -  MPEG; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",10"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpe\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg; ValueType: string; ValueData: KMP -  MPEG; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",11"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpeg\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg; ValueType: string; ValueData: KMP -  MPEG; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",12"
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.mpg\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg; ValueType: string; ValueData: KMP - NRG  CD; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",84"
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.nrg\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr; ValueType: string; ValueData: KMP - OFR ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",85"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ofr\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg; ValueType: string; ValueData: KMP -  Ogg Vorbis; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",28"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogg\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm; ValueType: string; ValueData: KMP -  OGM Vorbis; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",29"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ogm\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.part; ValueType: string; ValueData: KMP - PART  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",86"
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.part\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.pls; ValueType: string; ValueData: KMP -   Winamp; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",19"
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.pls\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.psb; ValueType: string; ValueData: KMP -   PSB; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",36"
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.psb\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.qt; ValueType: string; ValueData: KMP -  Apple QuickTime; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",13"
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.qt\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ra; ValueType: string; ValueData: KMP -  RealMedia; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",21"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ra\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ram; ValueType: string; ValueData: KMP -  RealMedia; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",25"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ram\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.rm; ValueType: string; ValueData: KMP -  RealMedia; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",22"
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rm\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj; ValueType: string; ValueData: KMP -  RealMedia; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",23"
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmj\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm; ValueType: string; ValueData: KMP -  RealMedia; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",26"
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmm\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.rms; ValueType: string; ValueData: KMP -  RealMedia; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",24"
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rms\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb; ValueType: string; ValueData: KMP -  RealMedia; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",27"
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rmvb\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.rt; ValueType: string; ValueData: KMP -   RT; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",31"
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.rt\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k; ValueType: string; ValueData: KMP -   S2K; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",38"
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.s2k\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.smi; ValueType: string; ValueData: KMP -   SMIL; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",18"
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.smi\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.srt; ValueType: string; ValueData: KMP -   SRT; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",37"
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.srt\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa; ValueType: string; ValueData: KMP -   SSA; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",35"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ssa\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.sub; ValueType: string; ValueData: KMP -   SUB; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",32"
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.sub\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.swf; ValueType: string; ValueData: KMP - SWF  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",96"
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.swf\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.tp; ValueType: string; ValueData: KMP - TP ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",97"
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.tp\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.trp; ValueType: string; ValueData: KMP - TRP  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",110"
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.trp\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.ts; ValueType: string; ValueData: KMP - TS ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",99"
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.ts\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.vob; ValueType: string; ValueData: KMP -  DVD; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",14"
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.vob\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6; ValueType: string; ValueData: KMP - VP6  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",101"
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.vp6\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.wav; ValueType: string; ValueData: KMP -   Windows; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",15"
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wav\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.wax; ValueType: string; ValueData: KMP - WAX  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",102"
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wax\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.wma; ValueType: string; ValueData: KMP -  Windows Media; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",16"
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wma\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv; ValueType: string; ValueData: KMP -  Windows Media; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",17"
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmv\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx; ValueType: string; ValueData: KMP - WMX  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",105"
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wmx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx; ValueType: string; ValueData: KMP - WVX  ; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\CLSID; ValueType: string; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\DefaultIcon; ValueType: string; ValueData: """{app}\KIconLib.dll"",107"
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\shell\Enqueue; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\shell\Enqueue\command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\shell\Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\shell\open\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\shell\open\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\shell\play; ValueType: string; ValueData:   KMP
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\shell\play\command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\KMPlayer.wvx\shell\play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

;  
Root: HKLM; SubKey: Software\RegisteredApplications; ValueType: string; ValueName: KMPlayer; ValueData: Software\Clients\Media\KMPlayer\Capabilities; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKLM; SubKey: Software\Clients\Media\KMPlayer; Flags: deletekey uninsdeletekey
Root: HKLM; SubKey: Software\Clients\Media\KMPlayer\Capabilities; ValueType: string; ValueName: ApplicationIcon; ValueData: """{#AppExe},0"""
Root: HKLM; SubKey: Software\Clients\Media\KMPlayer\Capabilities; ValueType: string; ValueName: ApplicationName; ValueData: {#AppName}
Root: HKLM; SubKey: Software\Clients\Media\KMPlayer\Capabilities; ValueType: string; ValueName: ApplicationDescription; ValueData: -   

Root: HKLM; SubKey: Software\Clients\Media\KMPlayer\DefaultIcon; ValueType: string; ValueData: """{#AppExe},0"""
Root: HKLM; SubKey: Software\Clients\Media\KMPlayer\Shell\Open\Command; ValueType: string; ValueData: """{#AppExe}"""

;   
Root: HKLM; SubKey: Software\Classes\Directory\shell\KMPlayer.Enqueue; ValueType: string; ValueData:   KMP; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\Directory\shell\KMPlayer.Enqueue\Command; ValueType: string; ValueData: """{#AppExe}"" /ADD ""%1"""
Root: HKLM; SubKey: Software\Classes\Directory\shell\KMPlayer.Enqueue\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{6E7D4AE2-770B-4F0D-9365-FEAD8DED17CD}
Root: HKLM; SubKey: Software\Classes\Directory\shell\KMPlayer.Play; ValueType: string; ValueData:   KMP; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Classes\Directory\shell\KMPlayer.Play\Command; ValueType: string; ValueData: """{#AppExe}"" ""%1"""
Root: HKLM; SubKey: Software\Classes\Directory\shell\KMPlayer.Play\DropTarget; ValueType: string; ValueName: Clsid; ValueData: {{9EB4C4CB-74C2-4BE9-AA5D-8249F16020AD}

;     
Root: HKLM; SubKey: Software\Classes\KMPlayer.AutoRun; Flags: uninsdeletekey

Root: HKLM; SubKey: Software\Classes\KMPlayer.AutoRun\shell\PlayCDAudio\Command; ValueType: string; ValueData: {#AppExe} %1 /cd; Tasks: autoplay\audiocd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayCDAudioOnArrival; ValueType: string; ValueName: KMPPlayCDAudioOnArrival; Flags: uninsdeletevalue; Tasks: autoplay\audiocd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: Action; ValueData:   CD; Flags: uninsdeletekey; Tasks: autoplay\audiocd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: Provider; ValueData: KMPlayer; Tasks: autoplay\audiocd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: InvokeProgID; ValueData: KMPlayer.AutoRun; Tasks: autoplay\audiocd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: InvokeVerb; ValueData: PlayCDAudio; Tasks: autoplay\audiocd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayCDAudioOnArrival; ValueType: string; ValueName: DefaultIcon; ValueData: {#AppExe},0; Tasks: autoplay\audiocd

Root: HKLM; SubKey: Software\Classes\KMPlayer.AutoRun\shell\PlayDVDMovie\Command; ValueType: string; ValueData: {#AppExe} %1 /dvd; Tasks: autoplay\videodvd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayDVDMovieOnArrival; ValueType: string; ValueName: KMPPlayDVDMovieOnArrival; Flags: uninsdeletevalue; Tasks: autoplay\videodvd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: Action; ValueData:  DVD; Flags: uninsdeletekey; Tasks: autoplay\videodvd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: Provider; ValueData: KMPlayer; Tasks: autoplay\videodvd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: InvokeProgID; ValueData: KMPlayer.AutoRun; Tasks: autoplay\videodvd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: InvokeVerb; ValueData: PlayDVDMovie; Tasks: autoplay\videodvd
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayDVDMovieOnArrival; ValueType: string; ValueName: DefaultIcon; ValueData: {#AppExe},0; Tasks: autoplay\videodvd

Root: HKLM; SubKey: Software\Classes\KMPlayer.AutoRun\shell\PlayMusicFiles\Command; ValueType: string; ValueData: {#AppExe} %1; Tasks: autoplay\audiofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayMusicFilesOnArrival; ValueType: string; ValueName: KMPPlayMusicFilesOnArrival; Flags: uninsdeletevalue; Tasks: autoplay\audiofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: Action; ValueData:   CD; Flags: uninsdeletekey; Tasks: autoplay\audiofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: Provider; ValueData: KMPlayer; Tasks: autoplay\audiofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: InvokeProgID; ValueData: KMPlayer.AutoRun; Tasks: autoplay\audiofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: InvokeVerb; ValueData: PlayMusicFiles; Tasks: autoplay\audiofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayMusicFilesOnArrival; ValueType: string; ValueName: DefaultIcon; ValueData: {#AppExe},0; Tasks: autoplay\audiofile

Root: HKLM; SubKey: Software\Classes\KMPlayer.AutoRun\shell\PlayVideoFiles\Command; ValueType: string; ValueData: {#AppExe} %1; Tasks: autoplay\videofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayVideoFilesOnArrival; ValueType: string; ValueName: KMPPlayVideoFilesOnArrival; Flags: uninsdeletevalue; Tasks: autoplay\videofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: Action; ValueData:   CD; Flags: uninsdeletekey; Tasks: autoplay\videofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: Provider; ValueData: KMPlayer; Tasks: autoplay\videofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: InvokeProgID; ValueData: KMPlayer.AutoRun; Tasks: autoplay\videofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: InvokeVerb; ValueData: PlayVideoFiles; Tasks: autoplay\videofile
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\KMPPlayVideoFilesOnArrival; ValueType: string; ValueName: DefaultIcon; ValueData: {#AppExe},0; Tasks: autoplay\videofile

;   
Root: HKLM; SubKey: Software\Classes\.kpl; ValueType: string; ValueData: KMPlayer.kpl; BeforeInstall: BackupExt ('kpl')
Root: HKLM; SubKey: Software\Classes\.ksf; ValueType: string; ValueData: KMPlayer.ksf; BeforeInstall: BackupExt ('ksf')

;   
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: dword; ValueName: ImageExtFilterUse; ValueData: 0
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: dword; ValueName: ImgExtFilterUse; ValueData: 1
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: dword; ValueName: OtherExtFilterUse; ValueData: 1

Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: string; ValueName: ImageExtFilterMsg
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: string; ValueName: ImgExtFilterMsg; ValueData: "BIN;IMG;ISO;NRG"
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: string; ValueName: OtherExtFilterMsg; ValueData: "FLC;FLI;MMS;OGM;PART"

Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: dword; ValueName: AudioExtFilterUse; ValueData: 1
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: dword; ValueName: VideoExtFilterUse; ValueData: 1
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: dword; ValueName: PlayListExtFilterUse; ValueData: 1
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: dword; ValueName: SubtitleExtFilterUse; ValueData: 1

Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: string; ValueName: AudioExtFilterMsg; ValueData: "AAC;AC3;APE;CDA;DTS;FLAC;M4A;MID;MKA;MP2;MP3;MPA;MPC;OFR;OGG;WAV;WMA"
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: string; ValueName: VideoExtFilterMsg; ValueData: "3GP;ASF;ASX;AVI;AVI_NEO_;DIVX;IFO;FLV;M1V;M2V;M4V;MKV;MOV;MP4;MPE;MPEG;MPG;QT;SWF;RA;RAM;RM;RMJ;RMM;RMS;RMVB;TP;TRP;TS;VOB;VP6;WMV"
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: string; ValueName: PlayListExtFilterMsg; ValueData: "KPL;ASX;M3U;PLS;WAX;WMX;WVX"
Root: HKCU; SubKey: Software\KMPlayer\KMP2.0; ValueType: string; ValueName: SubtitleExtFilterMsg; ValueData: "ASS;IDX;PSB;RT;S2K;SMI;SRT;SSA;SUB"

; - (aac|ac3|ape|cda|dts|flac|m4a|mid|mka|mp2|mp3|mpa|mpc|ofr|ogg|wav|wma)
Root: HKLM; SubKey: Software\Classes\.aac; ValueType: string; ValueData: KMPlayer.aac; Tasks: filetypes\audio; BeforeInstall: BackupExt ('aac')
Root: HKLM; SubKey: Software\Classes\.ac3; ValueType: string; ValueData: KMPlayer.ac3; Tasks: filetypes\audio; BeforeInstall: BackupExt ('ac3')
Root: HKLM; SubKey: Software\Classes\.ape; ValueType: string; ValueData: KMPlayer.ape; Tasks: filetypes\audio; BeforeInstall: BackupExt ('ape')
Root: HKLM; SubKey: Software\Classes\.cda; ValueType: string; ValueData: KMPlayer.cda; Tasks: filetypes\audio; BeforeInstall: BackupExt ('cda')
Root: HKLM; SubKey: Software\Classes\.dts; ValueType: string; ValueData: KMPlayer.dts; Tasks: filetypes\audio; BeforeInstall: BackupExt ('dts')
Root: HKLM; SubKey: Software\Classes\.flac; ValueType: string; ValueData: KMPlayer.flac; Tasks: filetypes\audio; BeforeInstall: BackupExt ('flac')
Root: HKLM; SubKey: Software\Classes\.m4a; ValueType: string; ValueData: KMPlayer.m4a; Tasks: filetypes\audio; BeforeInstall: BackupExt ('m4a')
Root: HKLM; SubKey: Software\Classes\.mid; ValueType: string; ValueData: KMPlayer.mid; Tasks: filetypes\audio; BeforeInstall: BackupExt ('mid')
Root: HKLM; SubKey: Software\Classes\.mka; ValueType: string; ValueData: KMPlayer.mka; Tasks: filetypes\audio; BeforeInstall: BackupExt ('mka')
Root: HKLM; SubKey: Software\Classes\.mp2; ValueType: string; ValueData: KMPlayer.mp2; Tasks: filetypes\audio; BeforeInstall: BackupExt ('mp2')
Root: HKLM; SubKey: Software\Classes\.mp3; ValueType: string; ValueData: KMPlayer.mp3; Tasks: filetypes\audio; BeforeInstall: BackupExt ('mp3')
Root: HKLM; SubKey: Software\Classes\.mpa; ValueType: string; ValueData: KMPlayer.mpa; Tasks: filetypes\audio; BeforeInstall: BackupExt ('mpa')
Root: HKLM; SubKey: Software\Classes\.mpc; ValueType: string; ValueData: KMPlayer.mpc; Tasks: filetypes\audio; BeforeInstall: BackupExt ('mpc')
Root: HKLM; SubKey: Software\Classes\.ofr; ValueType: string; ValueData: KMPlayer.ofr; Tasks: filetypes\audio; BeforeInstall: BackupExt ('ofr')
Root: HKLM; SubKey: Software\Classes\.ogg; ValueType: string; ValueData: KMPlayer.ogg; Tasks: filetypes\audio; BeforeInstall: BackupExt ('ogg')
Root: HKLM; SubKey: Software\Classes\.wav; ValueType: string; ValueData: KMPlayer.wav; Tasks: filetypes\audio; BeforeInstall: BackupExt ('wav')
Root: HKLM; SubKey: Software\Classes\.wma; ValueType: string; ValueData: KMPlayer.wma; Tasks: filetypes\audio; BeforeInstall: BackupExt ('wma')

;  (3gp|asf|asx|avi|avi_neo_|dat|divx|ifo|flv|m1v|m2v|m4v|mkv|mov|mp4|mpe|mpeg|mpg|qt|swf|ra|ram|rm|rmj|rmm|rms|rmvb|tp|trp|ts|vob|vp6|wmv)
Root: HKLM; SubKey: Software\Classes\.3gp; ValueType: string; ValueData: KMPlayer.3gp; Tasks: filetypes\video; BeforeInstall: BackupExt ('3gp')
Root: HKLM; SubKey: Software\Classes\.asf; ValueType: string; ValueData: KMPlayer.asf; Tasks: filetypes\video; BeforeInstall: BackupExt ('asf')
Root: HKLM; SubKey: Software\Classes\.asx; ValueType: string; ValueData: KMPlayer.asx; Tasks: filetypes\video; BeforeInstall: BackupExt ('asx')
Root: HKLM; SubKey: Software\Classes\.avi; ValueType: string; ValueData: KMPlayer.avi; Tasks: filetypes\video; BeforeInstall: BackupExt ('avi')
Root: HKLM; SubKey: Software\Classes\.avi_neo_; ValueType: string; ValueData: KMPlayer.avi_neo_; Tasks: filetypes\video; BeforeInstall: BackupExt ('avi_neo_')
Root: HKLM; SubKey: Software\Classes\.dat; ValueType: string; ValueData: KMPlayer.dat; Tasks: filetypes\video; BeforeInstall: BackupExt ('dat')
Root: HKLM; SubKey: Software\Classes\.divx; ValueType: string; ValueData: KMPlayer.divx; Tasks: filetypes\video; BeforeInstall: BackupExt ('divx')
Root: HKLM; SubKey: Software\Classes\.ifo; ValueType: string; ValueData: KMPlayer.ifo; Tasks: filetypes\video; BeforeInstall: BackupExt ('ifo')
Root: HKLM; SubKey: Software\Classes\.flv; ValueType: string; ValueData: KMPlayer.flv; Tasks: filetypes\video; BeforeInstall: BackupExt ('flv')
Root: HKLM; SubKey: Software\Classes\.m1v; ValueType: string; ValueData: KMPlayer.m1v; Tasks: filetypes\video; BeforeInstall: BackupExt ('m1v')
Root: HKLM; SubKey: Software\Classes\.m2v; ValueType: string; ValueData: KMPlayer.m2v; Tasks: filetypes\video; BeforeInstall: BackupExt ('m2v')
Root: HKLM; SubKey: Software\Classes\.m4v; ValueType: string; ValueData: KMPlayer.m4v; Tasks: filetypes\video; BeforeInstall: BackupExt ('m4v')
Root: HKLM; SubKey: Software\Classes\.mkv; ValueType: string; ValueData: KMPlayer.mkv; Tasks: filetypes\video; BeforeInstall: BackupExt ('mkv')
Root: HKLM; SubKey: Software\Classes\.mov; ValueType: string; ValueData: KMPlayer.mov; Tasks: filetypes\video; BeforeInstall: BackupExt ('mov')
Root: HKLM; SubKey: Software\Classes\.mp4; ValueType: string; ValueData: KMPlayer.mp4; Tasks: filetypes\video; BeforeInstall: BackupExt ('mp4')
Root: HKLM; SubKey: Software\Classes\.mpe; ValueType: string; ValueData: KMPlayer.mpe; Tasks: filetypes\video; BeforeInstall: BackupExt ('mpe')
Root: HKLM; SubKey: Software\Classes\.mpeg; ValueType: string; ValueData: KMPlayer.mpeg; Tasks: filetypes\video; BeforeInstall: BackupExt ('mpeg')
Root: HKLM; SubKey: Software\Classes\.mpg; ValueType: string; ValueData: KMPlayer.mpg; Tasks: filetypes\video; BeforeInstall: BackupExt ('mpg')
Root: HKLM; SubKey: Software\Classes\.qt; ValueType: string; ValueData: KMPlayer.qt; Tasks: filetypes\video; BeforeInstall: BackupExt ('qt')
Root: HKLM; SubKey: Software\Classes\.swf; ValueType: string; ValueData: KMPlayer.swf; Tasks: filetypes\video; BeforeInstall: BackupExt ('swf')
Root: HKLM; SubKey: Software\Classes\.ra; ValueType: string; ValueData: KMPlayer.ra; Tasks: filetypes\video; BeforeInstall: BackupExt ('ra')
Root: HKLM; SubKey: Software\Classes\.ram; ValueType: string; ValueData: KMPlayer.ram; Tasks: filetypes\video; BeforeInstall: BackupExt ('ram')
Root: HKLM; SubKey: Software\Classes\.rm; ValueType: string; ValueData: KMPlayer.rm; Tasks: filetypes\video; BeforeInstall: BackupExt ('rm')
Root: HKLM; SubKey: Software\Classes\.rmj; ValueType: string; ValueData: KMPlayer.rmj; Tasks: filetypes\video; BeforeInstall: BackupExt ('rmj')
Root: HKLM; SubKey: Software\Classes\.rmm; ValueType: string; ValueData: KMPlayer.rmm; Tasks: filetypes\video; BeforeInstall: BackupExt ('rmm')
Root: HKLM; SubKey: Software\Classes\.rms; ValueType: string; ValueData: KMPlayer.rms; Tasks: filetypes\video; BeforeInstall: BackupExt ('rms')
Root: HKLM; SubKey: Software\Classes\.rmvb; ValueType: string; ValueData: KMPlayer.rmvb; Tasks: filetypes\video; BeforeInstall: BackupExt ('rmvb')
Root: HKLM; SubKey: Software\Classes\.tp; ValueType: string; ValueData: KMPlayer.tp; Tasks: filetypes\video; BeforeInstall: BackupExt ('tp')
Root: HKLM; SubKey: Software\Classes\.trp; ValueType: string; ValueData: KMPlayer.trp; Tasks: filetypes\video; BeforeInstall: BackupExt ('trp')
Root: HKLM; SubKey: Software\Classes\.ts; ValueType: string; ValueData: KMPlayer.ts; Tasks: filetypes\video; BeforeInstall: BackupExt ('ts')
Root: HKLM; SubKey: Software\Classes\.vob; ValueType: string; ValueData: KMPlayer.vob; Tasks: filetypes\video; BeforeInstall: BackupExt ('vob')
Root: HKLM; SubKey: Software\Classes\.vp6; ValueType: string; ValueData: KMPlayer.vp6; Tasks: filetypes\video; BeforeInstall: BackupExt ('vp6')
Root: HKLM; SubKey: Software\Classes\.wmv; ValueType: string; ValueData: KMPlayer.wmv; Tasks: filetypes\video; BeforeInstall: BackupExt ('wmv')

;  (asx|m3u|pls|wax|wmx|wvx)
Root: HKLM; SubKey: Software\Classes\.asx; ValueType: string; ValueData: KMPlayer.asx; Tasks: filetypes\pls; BeforeInstall: BackupExt ('asx')
Root: HKLM; SubKey: Software\Classes\.m3u; ValueType: string; ValueData: KMPlayer.m3u; Tasks: filetypes\pls; BeforeInstall: BackupExt ('m3u')
Root: HKLM; SubKey: Software\Classes\.pls; ValueType: string; ValueData: KMPlayer.pls; Tasks: filetypes\pls; BeforeInstall: BackupExt ('pls')
Root: HKLM; SubKey: Software\Classes\.wax; ValueType: string; ValueData: KMPlayer.wax; Tasks: filetypes\pls; BeforeInstall: BackupExt ('wax')
Root: HKLM; SubKey: Software\Classes\.wmx; ValueType: string; ValueData: KMPlayer.wmx; Tasks: filetypes\pls; BeforeInstall: BackupExt ('wmx')
Root: HKLM; SubKey: Software\Classes\.wvx; ValueType: string; ValueData: KMPlayer.wvx; Tasks: filetypes\pls; BeforeInstall: BackupExt ('wvx')

;  (ass|idx|psb|rt|s2k|smi|srt|ssa|sub)
Root: HKLM; SubKey: Software\Classes\.ass; ValueType: string; ValueData: KMPlayer.ass; Tasks: filetypes\sub; BeforeInstall: BackupExt ('ass')
Root: HKLM; SubKey: Software\Classes\.idx; ValueType: string; ValueData: KMPlayer.idx; Tasks: filetypes\sub; BeforeInstall: BackupExt ('idx')
Root: HKLM; SubKey: Software\Classes\.psb; ValueType: string; ValueData: KMPlayer.psb; Tasks: filetypes\sub; BeforeInstall: BackupExt ('psb')
Root: HKLM; SubKey: Software\Classes\.rt; ValueType: string; ValueData: KMPlayer.rt; Tasks: filetypes\sub; BeforeInstall: BackupExt ('rt')
Root: HKLM; SubKey: Software\Classes\.s2k; ValueType: string; ValueData: KMPlayer.s2k; Tasks: filetypes\sub; BeforeInstall: BackupExt ('s2k')
Root: HKLM; SubKey: Software\Classes\.smi; ValueType: string; ValueData: KMPlayer.smi; Tasks: filetypes\sub; BeforeInstall: BackupExt ('smi')
Root: HKLM; SubKey: Software\Classes\.srt; ValueType: string; ValueData: KMPlayer.srt; Tasks: filetypes\sub; BeforeInstall: BackupExt ('srt')
Root: HKLM; SubKey: Software\Classes\.ssa; ValueType: string; ValueData: KMPlayer.ssa; Tasks: filetypes\sub; BeforeInstall: BackupExt ('ssa')
Root: HKLM; SubKey: Software\Classes\.sub; ValueType: string; ValueData: KMPlayer.sub; Tasks: filetypes\sub; BeforeInstall: BackupExt ('sub')

[Run]
Filename: {win}\Regedit.exe; Parameters: "/S ""{src}\{#AppName}.reg"""; WorkingDir: {src}; Check: FileExists (ExpandConstant ('{src}\{#AppName}.reg')); StatusMsg: "  ..."; Flags: skipifdoesntexist
Filename: {#AppExe}; Parameters: -install; WorkingDir: {app}
Filename: {#AppExe}; Description: {cm:LaunchProgram,{#AppName}}; WorkingDir: {app}; Flags: nowait postinstall skipifsilent

[InstallDelete]
Name: {app}\PlugIns\gen_ml.dll; Type: files; MinVersion: 0,6
Name: {app}\PlugIns\gen_ml.ini; Type: files; MinVersion: 0,6

[UninstallDelete]
Name: {app}\Playlist; Type: filesandordirs
Name: {app}\KMPlayer.ini; Type: files
Name: {app}\Files.txt; Type: files
Name: {app}\GPL.txt; Type: files
Name: {app}\LGPL.TXT; Type: files
Name: {app}\URLList.txt; Type: files

[Code]
Const
	FileTypes		= 'kpl|ksf|aac|ac3|ape|cda|dts|flac|m4a|mid|mka|mp2|mp3|mpa|mpc|ofr|ogg|wav|wma|3gp|asf|asx|avi|avi_neo_|dat|divx|ifo|flv|m1v|m2v|m4v|mkv|mov|mp4|mpe|mpeg|mpg|qt|swf|ra|ram|rm|rmj|rmm|rms|rmvb|tp|trp|ts|vob|vp6|wmv|asx|m3u|pls|wax|wmx|wvx|ass|idx|psb|rt|s2k|smi|srt|ssa|sub|mms|ogm|bin|img|iso|nrg|part|flc|fli';
	BackupName		= 'KMPBackup.bak';
	AppClassMask		= 'KMPlayer.%ext%';
	HKLM_Class		= 1;
	HKCU_Class		= 0;
	FileExt			= 0;
	AppCapsRegPath		= 'Software\Clients\Media\KMPlayer\Capabilities';
	AddOpenWith		= 1;
	BackupExtsTask		= '';

function GetProgsDir (nillest : String) : String;
begin
	if IsAdminLoggedOn() then
		result := ExpandConstant ('{commonprograms}')
	else
		result := ExpandConstant ('{userprograms}');
end;

function GetProgsCatName (nillest : String) : String;
begin
	result := WizardGroupValue ();
end;

#include AddBackslash(SourcePath) + "Assoc_Helper.iss"