#include-once

Func CreateForm_frmDeletePartition(ByRef $afrmNew, $frmParent)

	Dim $afrmNew[12][2]

	$afrmNew[0][0] = "$frmDeletePartition"
	$afrmNew[0][1] = GUICreate("Delete Partition", 384, 250, (@DesktopWidth - 100)/2, (@DesktopHeight - 274)/2, _
									BitOr($WS_CAPTION, $WS_SYSMENU, $WS_POPUP), -1, $frmParent)
	$afrmNew[1][0] = "$icoDelete"
	$afrmNew[1][1] = GUICtrlCreateIcon("shell32.dll", 50, 8, 8, 32, 32)
	GUICtrlCreateLabel("Warning: The selected partition may contain user data." & @CRLF & _
					"Continuing will erase any existing data on the partition.", 51, 10, 325, 35);, -1, $WS_EX_STATICEDGE)
					GUICtrlSetFont(-1, 8.5, 600)

	GUICtrlCreateGroup("Partition Information:", 8, 49, 368, 105)
	$afrmNew[2][0] = "$lblPartLocation"
	$afrmNew[2][1] = GUICtrlCreateLabel("", 16, 70, 352, 17, $SS_CENTER, $WS_EX_STATICEDGE)
					GUICtrlSetFont(-1, 8.5, 600)
	$afrmNew[3][0] = "$lblPartType"
	$afrmNew[3][1] = GUICtrlCreateLabel("Type: ", 16, 95, 105, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[4][0] = "$lblPartSize"
	$afrmNew[4][1] = GUICtrlCreateLabel("Size: ", 16, 120, 105, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[5][0] = "$lblPartLabel"
	$afrmNew[5][1] = GUICtrlCreateLabel("Label: ", 123, 95, 122, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[6][0] = "$lblDriveLetter"
	$afrmNew[6][1] = GUICtrlCreateLabel("Letter: ", 123, 120, 122, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[7][0] = "$lblPartFS"
	$afrmNew[7][1] = GUICtrlCreateLabel("File System: ", 247, 95, 122, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[8][0] = "$lblPartActive"
	$afrmNew[8][1] = GUICtrlCreateLabel("Active: ", 247, 120, 122, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)

	GUICtrlCreateLabel("Are you sure you want to delete this partition?", 8, 161, 368, 17, $SS_CENTER);, $WS_EX_STATICEDGE)
					GUICtrlSetFont(-1, 8.5, 600)
	$afrmNew[9][0] = "$chkConfirmDelete"
	$afrmNew[9][1] = GUICtrlCreateCheckbox("&Delete partition and erase any existing data.", 8, 185, 368, 17 )
	$afrmNew[10][0] = "$cmdDelete"
	$afrmNew[10][1] = GUICtrlCreateButton("Delete", 222, 216, 75, 25, $WS_DISABLED)
	$afrmNew[11][0] = "$cmdCancel"
	$afrmNew[11][1] = GUICtrlCreateButton("Cancel", 302, 216, 75, 25, $BS_DEFPUSHBUTTON)
EndFunc

Func frmDeletePartition_Initialize()
	Local $iDiskIndex, $iPartIndex, $lvwPartitions
	Local $chkConfirmDelete, $cmdDelete

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	$chkConfirmDelete = _GetCtrl("$chkConfirmDelete", $afrmDeletePartition)
	$cmdDelete = _GetCtrl("$cmdDelete", $afrmDeletePartition)

	GUICtrlSetData(_GetCtrl("$lblPartLocation", $afrmDeletePartition), $asPartitions[$iPartIndex][0] & " on " & $asDisks[$iDiskIndex][6])
	GUICtrlSetData(_GetCtrl("$lblPartType", $afrmDeletePartition), "Type: " & $asPartitions[$iPartIndex][1])
	GUICtrlSetData(_GetCtrl("$lblPartSize", $afrmDeletePartition), "Size: " & $asPartitions[$iPartIndex][2])
	GUICtrlSetData(_GetCtrl("$lblPartLabel", $afrmDeletePartition), "Label: " & $asPartitions[$iPartIndex][6])
	GUICtrlSetData(_GetCtrl("$lblDriveLetter", $afrmDeletePartition), "Letter: " & $asPartitions[$iPartIndex][5])
	GUICtrlSetData(_GetCtrl("$lblPartFS", $afrmDeletePartition), "File System: " & $asPartitions[$iPartIndex][7])
	GUICtrlSetData(_GetCtrl("$lblPartActive", $afrmDeletePartition), "Active: " & $asPartitions[$iPartIndex][13])

	frmDeletePartition_LoadIcons()
	GUICtrlSetState($chkConfirmDelete, $GUI_UNCHECKED)
	GUICtrlSetState($cmdDelete, $GUI_DISABLE)

EndFunc

Func frmDeletePartition_WndProc()

	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		GUISetState(@SW_ENABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_HIDE, $afrmDeletePartition[0][1])
	Case $msg[0] = _GetCtrl("$chkConfirmDelete", $afrmDeletePartition)
		frmDeletePartition_chkConfirmDelete_Click()
	Case $msg[0] = _GetCtrl("$cmdDelete", $afrmDeletePartition)
		frmDeletePartition_cmdDelete_Click()
	Case $msg[0] = _GetCtrl("$cmdCancel", $afrmDeletePartition)
		$msg[0] = $GUI_EVENT_CLOSE
		frmDeletePartition_WndProc()
	EndSelect
EndFunc

Func frmDeletePartition_LoadIcons()
	If @compiled = 1 Then
		GUICtrlSetImage(_GetCtrl("$icoDelete", $afrmDeletePartition), @ScriptFullPath, 2)
	Else
		GUISetIcon("icons\0.ico", 0, $afrmDeletePartition[0][1])
		GUICtrlSetImage(_GetCtrl("$icoDelete", $afrmDeletePartition), "icons\2.ico", 0)
	EndIf
EndFunc

Func frmDeletePartition_chkConfirmDelete_Click()
	Local $chkConfirmDelete, $cmdDelete, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$chkConfirmDelete = _GetCtrl("$chkConfirmDelete", $afrmDeletePartition)
	$cmdDelete = _GetCtrl("$cmdDelete", $afrmDeletePartition)

	If GUICtrlRead($chkConfirmDelete) = $GUI_CHECKED Then
		GUICtrlSetState($cmdDelete, $GUI_ENABLE)
	ElseIf GUICtrlRead($chkConfirmDelete) = $GUI_UNCHECKED Then
		GUICtrlSetState($cmdDelete, $GUI_DISABLE)
	EndIf
EndFunc

Func frmDeletePartition_cmdDelete_Click()
	Local $iPartIndex
	Local $lvwPartitions, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")

	$msg[0] = $GUI_EVENT_CLOSE
	frmDeletePartition_WndProc()

	ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
	frmDiskPart_ChangeControlState()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
	GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

	_DeletePartition($sCurrentDisk, $asPartitions[$iPartIndex][0], False, $stbStatus)

	frmSelectDisk_LoadDisks()
	frmDiskPart_LoadPartitions()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
EndFunc

