#include-once

Func CreateForm_frmDiskPart(ByRef $afrmNew)

	Dim $afrmNew[23][2]

	$afrmNew[0][0] = "$frmDiskPart"
	$afrmNew[0][1] = GUICreate("Disk Partitioner", 398, 450, (@DesktopWidth - 405)/2, (@DesktopHeight - 457)/2)

	GUICtrlCreateGroup("Selected Drive:", 8, 8, 381, 73)
	$afrmNew[1][0] = "$icoDrive"
	$afrmNew[1][1] = GUICtrlCreateIcon ("shell32.dll", 50, 24, 32, 32, 32)
	$afrmNew[2][0] = "$lblDiskLabel"
	$afrmNew[2][1] = GUICtrlCreateLabel("", 90, 30, 200, 16, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
					GUICtrlSetFont(-1, 8.5, 600)
	GUICtrlCreateLabel("Disk #: ", 90, 50, 43, 21)
	$afrmNew[3][0] = "$lblDiskNo"
	$afrmNew[3][1] = GUICtrlCreateLabel("", 126, 50, 30, 21, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[4][0] = "$lblDiskType"
	$afrmNew[4][1] = GUICtrlCreateLabel("Type:", 168, 50, 75, 21, $SS_LEFTNOWORDWRAP)
	$afrmNew[5][0] = "$lblDiskSize"
	$afrmNew[5][1] = GUICtrlCreateLabel("Size:", 250, 50, 80, 21, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[6][0] = "$cmdDiskBrowse"
	$afrmNew[6][1] = GUICtrlCreateButton("...", 344, 34, 33, 27)

	GUICtrlCreateLabel("Available Partitions:", 8, 89, 100, 13)
	GUICtrlCreateGroup("", 8, 100, 381, 201)
	$afrmNew[7][0] = "$lvwPartitions"
	$afrmNew[7][1] = GUICtrlCreateListView("Partition|Type|Capacity|Free Space|File System", 16, 115, 361, 144, _
					BitOr($LVS_SHOWSELALWAYS, $LVS_SINGLESEL, $LVS_NOSORTHEADER))
					GUICtrlSendMsg(-1, $LVM_SETEXTENDEDLISTVIEWSTYLE, $LVS_EX_GRIDLINES, $LVS_EX_GRIDLINES)
	;GUICtrlCreateGroup("", 16, 254, 361, 9)
	$afrmNew[8][0] = "$cmdAdd"
	$afrmNew[8][1] = GUICtrlCreateButton("&Add...", 16, 267, 75, 25, $WS_DISABLED)
	$afrmNew[9][0] = "$cmdDelete"
	$afrmNew[9][1] = GUICtrlCreateButton("&Delete", 96, 267, 75, 25, $WS_DISABLED)
	$afrmNew[10][0] = "$cmdEdit"
	$afrmNew[10][1] = GUICtrlCreateButton("&Edit...", 176, 267, 75, 25, $WS_DISABLED)
	$afrmNew[11][0] = "$cmdRefresh"
	$afrmNew[11][1] = GUICtrlCreateButton("&Refresh", 256, 267, 75, 25)

	GUICtrlCreateLabel("Partition Information:", 8, 309, 100, 13)
	GUICtrlCreateGroup("", 8, 320, 381, 101)

	GUICtrlCreateLabel("Volume #:", 16, 334, 60, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[12][0] = "$lblVolNo"
	$afrmNew[12][1] = GUICtrlCreateLabel("", 77, 334, 65, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Offset:", 16, 358, 60, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[13][0] = "$lblOffset"
	$afrmNew[13][1] = GUICtrlCreateLabel("", 77, 358, 65, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Hidden:", 143, 334, 45, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[14][0] = "$lblHidden"
	$afrmNew[14][1] = GUICtrlCreateLabel("", 189, 334, 65, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Active:", 143, 358, 45, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[15][0] = "$lblActive"
	$afrmNew[15][1] = GUICtrlCreateLabel("", 189, 358, 65, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Status:", 256, 334, 40, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[16][0] = "$lblStatus"
	$afrmNew[16][1] = GUICtrlCreateLabel("", 297, 334, 85, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Info:", 256, 358, 40, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[17][0] = "$lblInfo"
	$afrmNew[17][1] = GUICtrlCreateLabel("", 297, 358, 85, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)

	$afrmNew[18][0] = "$cmdFormat"
	$afrmNew[18][1] = GUICtrlCreateButton("&Format...", 16, 387, 75, 25, $WS_DISABLED)
	$afrmNew[19][0] = "$cmdCheck"
	$afrmNew[19][1] = GUICtrlCreateButton("&Check...", 96, 387, 75, 25, $WS_DISABLED)
	$afrmNew[20][0] = "$cmdDefrag"
	$afrmNew[20][1] = GUICtrlCreateButton("Defra&gment...", 176, 387, 75, 25, $WS_DISABLED)
	$afrmNew[21][0] = "$cmdProperties"
	$afrmNew[21][1] = GUICtrlCreateButton("&Properties...", 256, 387, 75, 25, $WS_DISABLED)
	$afrmNew[22][0] = "$stbStatus"
	$afrmNew[22][1] = GUICtrlCreateLabel("", 0, 432, 398, 18, -1, $WS_EX_STATICEDGE)
EndFunc

Func frmDiskPart_Initialize()

	frmDiskPart_LoadIcons()
	frmDiskPart_ChangeControlState()
EndFunc

Func frmDiskPart_WndProc()

	frmDiskPart_ChangeControlState()

	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		DiskPartitioner_WndProc()	; Send end application message if main window closed
	Case $msg[0] = _GetCtrl("$cmdDiskBrowse", $afrmDiskPart)
		frmSelectDisk_Initialize()
		GUISetState(@SW_DISABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_SHOW, $afrmSelectDisk[0][1])
	Case $msg[0] = _GetCtrl("$cmdAdd", $afrmDiskPart)
		frmDiskPart_cmdAdd_Click()
	Case $msg[0] = _GetCtrl("$cmdDelete", $afrmDiskPart)
		frmDiskPart_cmdDelete_Click()
	Case $msg[0] = _GetCtrl("$cmdEdit", $afrmDiskPart)
		frmEditPartition_Initialize()
		GUISetState(@SW_DISABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_SHOW, $afrmEditPartition[0][1])
	Case $msg[0] = _GetCtrl("$cmdRefresh", $afrmDiskPart)
		frmDiskPart_cmdRefresh_Click()
	Case $msg[0] = _GetCtrl("$cmdFormat", $afrmDiskPart)
		frmDiskPart_cmdFormat_Click()
	Case $msg[0] = _GetCtrl("$cmdCheck", $afrmDiskPart)
		frmDiskPart_cmdCheck_Click()
	Case $msg[0] = _GetCtrl("$cmdDefrag", $afrmDiskPart)
		frmDiskPart_cmdDefrag_Click()
	Case $msg[0] = _GetCtrl("$cmdProperties", $afrmDiskPart)
		frmDiskPart_cmdProperties_Click()

	EndSelect
EndFunc

Func frmDiskPart_ChangeControlState()
	Local $lvwPartitions, $iSelPart

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iSelPart = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")

	If  $iSelPart = "" Then
		GUICtrlSetState(_GetCtrl("$cmdDelete", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdEdit", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdFormat", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdCheck", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdDefrag", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdProperties", $afrmDiskPart), $GUI_DISABLE)
	ElseIf ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetText", $iSelPart, 1) = "Extended" Then
		GUICtrlSetState(_GetCtrl("$cmdDelete", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdEdit", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdFormat", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdCheck", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdDefrag", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdProperties", $afrmDiskPart), $GUI_DISABLE)
	Else
		GUICtrlSetState(_GetCtrl("$cmdDelete", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdEdit", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdFormat", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdCheck", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdDefrag", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdProperties", $afrmDiskPart), $GUI_ENABLE)
	EndIf

	If $iSelPart = "" Then
		GUICtrlSetData(_GetCtrl("$lblVolNo", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblOffset", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblHidden", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblActive", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblStatus", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblInfo", $afrmDiskPart), "")
	Else
		GUICtrlSetData(_GetCtrl("$lblVolNo", $afrmDiskPart), StringMid($asPartitions[$iSelPart][4], 8))
		GUICtrlSetData(_GetCtrl("$lblOffset", $afrmDiskPart), $asPartitions[$iSelPart][3])
		GUICtrlSetData(_GetCtrl("$lblHidden", $afrmDiskPart), $asPartitions[$iSelPart][12])
		GUICtrlSetData(_GetCtrl("$lblActive", $afrmDiskPart), $asPartitions[$iSelPart][13])
		GUICtrlSetData(_GetCtrl("$lblStatus", $afrmDiskPart), $asPartitions[$iSelPart][10])
		GUICtrlSetData(_GetCtrl("$lblInfo", $afrmDiskPart), $asPartitions[$iSelPart][11])
	EndIf
EndFunc

Func frmDiskPart_LoadIcons()
	If @compiled = 1 Then
		GUICtrlSetImage(_GetCtrl("$icoDrive", $afrmDiskPart), @ScriptFullPath, 0)
		GUICtrlSetImage(_GetCtrl("$lvwPartitions", $afrmDiskPart), @ScriptFullPath, 1)
	Else
		GUISetIcon("icons\0.ico", 0, $afrmDiskPart[0][1])
		GUICtrlSetImage(_GetCtrl("$icoDrive", $afrmDiskPart), "icons\0.ico", 0)
		GUICtrlSetImage(_GetCtrl("$lvwPartitions", $afrmDiskPart), "icons\1.ico", 0)
	EndIf
EndFunc

Func frmDiskPart_cmdAdd_Click()
	Local $iDiskIndex

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	If _ConvertToMB($asDisks[$iDiskIndex][3]) = 0 Then
		DiskPartitioner_ErrorHandler("All available space on this disk has been allocated.", "", "Non-Fatal")
	Else
		frmCreatePartition_Initialize()
		GUISetState(@SW_DISABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_SHOW, $afrmCreatePartition[0][1])
	EndIf
EndFunc

Func frmDiskPart_cmdDelete_Click()
	Local $iPartIndex, $bLogicalPresent
	Local $lvwPartitions, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")

	If $asPartitions[$iPartIndex][1] = "Extended" Then
		$bLogicalPresent = False
		For $i = 0 to UBound($asPartitions, 1) - 1
			If $asPartitions[$i][1] = "Logical" Then
				$bLogicalPresent = True
				ExitLoop
			EndIf
		Next

		If $bLogicalPresent Then
			DiskPartitioner_ErrorHandler("Cannot delete extended partition when logical drive(s) are present.", _
										"Delete all logical drives before removing the extended partition.", "Non-Fatal")
		Else
			; Delete extended without prompting when logical drives are not present
			ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
			frmDiskPart_ChangeControlState()

			GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
			GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

			_DeletePartition($sCurrentDisk, $asPartitions[$iPartIndex][0], True, $stbStatus)

			frmSelectDisk_LoadDisks()
			frmDiskPart_LoadPartitions()

			GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
		EndIf
	Else
		frmDeletePartition_Initialize()
		GUISetState(@SW_DISABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_SHOW, $afrmDeletePartition[0][1])
	EndIf
EndFunc

Func frmDiskPart_cmdRefresh_Click()
	Local $lvwPartitions, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
	frmDiskPart_ChangeControlState()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
	GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

	_RefreshDiskPartInfo($sCurrentDisk, $stbStatus)
	frmSelectDisk_LoadDisks()
	frmDiskPart_LoadPartitions()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
EndFunc

Func frmDiskPart_cmdFormat_Click()
	Local $SHFD_CAPACITY_DEFAULT = 0
	Local $SHMT_FORMAT_QUICK = 1  ;Quick format
	Local $SHMT_FORMAT_FULL = 0  ;Full format
	Local $iLetter, $sDriveLetter, $iPartIndex, $lvwPartitions

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	If $iPartIndex <> "" Then
		$sDriveLetter = $asPartitions[$iPartIndex][5]
		If $sDriveLetter = "" Then
			DiskPartitioner_ErrorHandler("No drive letter assigned.", "A drive letter must be assigned to format the selected partition.", "Non-Fatal")
			SetError(1)
			Return
		Else
			$iLetter = Asc($sDriveLetter) - 65
			DllCall("shell32.dll", "long", "SHFormatDrive", "hwnd", $afrmDiskPart[0][1], "int", $iLetter, _
				"int", $SHFD_CAPACITY_DEFAULT, "int", $SHMT_FORMAT_QUICK)
		EndIf
	EndIf
EndFunc

Func frmDiskPart_cmdCheck_Click()
	Local $sDriveLetter, $sDriveLabel, $iPartIndex, $lvwPartitions

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	If $iPartIndex <> "" Then
		$sDriveLetter = $asPartitions[$iPartIndex][5]
		If $sDriveLetter = "" Then
			DiskPartitioner_ErrorHandler("No drive letter assigned.", "A drive letter must be assigned to check the selected disk.", "Non-Fatal")
			SetError(1)
			Return
		Else
			$sDriveLabel = $asPartitions[$iPartIndex][6]
			If $sDriveLabel = "" Then $sDriveLabel = "Local Disk"
			DllCall("shell32.dll", "int", "SHObjectProperties", "hwnd", $afrmDiskPart[0][1], "int", 2, "wstr", $sDriveLetter & ":\", "wstr", "Tools")
			If WinWaitActive($sDriveLabel & " (" & $sDriveLetter & ":) Properties", "", 5) = 1 Then
				WinSetState ($sDriveLabel & " (" & $sDriveLetter & ":) Properties", "", @SW_HIDE)
				ControlClick ($sDriveLabel & " (" & $sDriveLetter & ":) Properties", "", "Button2")
			EndIf
			; Putting the $GUI_EVENT_CLOSE for the drive properties window closes it immediately after the check disk window exits.
			WinClose($sDriveLabel & " (" & $sDriveLetter & ":) Properties")
		EndIf
	EndIf
EndFunc

Func frmDiskPart_cmdDefrag_Click()
	Local $sDriveLetter, $iPartIndex, $lvwPartitions

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	If $iPartIndex <> "" Then
		$sDriveLetter = $asPartitions[$iPartIndex][5]
		If $sDriveLetter = "" Then
			DiskPartitioner_ErrorHandler("No drive letter assigned.", "A drive letter must be assigned to defragment the selected partition.", "Non-Fatal")
			Return
		ElseIf FileExists(@SystemDir & "\MMC.exe") And FileExists(@SystemDir & "\dfrg.msc") Then
			DllCall("shell32.dll", "long", "ShellExecute", "hwnd", $afrmDiskPart[0][1], "str", "", _
					"str", @SystemDir & "\dfrg.msc", "str", $sDriveLetter & ":", "str", @SystemDir, "long", @SW_SHOWNORMAL)
		EndIf
	EndIf
EndFunc

Func frmDiskPart_cmdProperties_Click()
	Local $sDriveLetter, $iPartIndex, $lvwPartitions

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	If $iPartIndex <> "" Then
		$sDriveLetter = $asPartitions[$iPartIndex][5]
		If $sDriveLetter = "" Then
			DiskPartitioner_ErrorHandler("No drive letter assigned.", "A drive letter must be assigned to partition for viewing properties.", "Non-Fatal")
			Return
		Else
			DllCall("shell32.dll", "int", "SHObjectProperties", "hwnd", $afrmDiskPart[0][1], "int", 2, "wstr", $sDriveLetter & ":\", "wstr", "")
		EndIf
	EndIf
EndFunc

Func frmDiskPart_LoadPartitions()
	Local $lvwPartitions, $sPartName, $sDriveFreeSpace

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	GUICtrlSendMsg($lvwPartitions, $LVM_DELETEALLITEMS, 0, 0)	; Delete all Items

	If $asDisks = 0 Then
		GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

		GUICtrlSetData(_GetCtrl("$lblDiskLabel", $afrmDiskPart), "(NO DISKS FOUND)")
		GUICtrlSetData(_GetCtrl("$lblDiskNo", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblDiskType", $afrmDiskPart), "Type: ")
		GUICtrlSetData(_GetCtrl("$lblDiskSize", $afrmDiskPart), "Size: ")
	Else
		GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_ENABLE)

		For $i = 0 to Ubound($asDisks, 1) - 1
			If $asDisks[$i][0] = $sCurrentDisk Then
				GUICtrlSetData(_GetCtrl("$lblDiskLabel", $afrmDiskPart), $asDisks[$i][6])
				GUICtrlSetData(_GetCtrl("$lblDiskNo", $afrmDiskPart), StringMid($asDisks[$i][0], 5))
				GUICtrlSetData(_GetCtrl("$lblDiskType", $afrmDiskPart), "Type: " & $asDisks[$i][8])
				GUICtrlSetData(_GetCtrl("$lblDiskSize", $afrmDiskPart), "Size: " & $asDisks[$i][2])

				ExitLoop
			EndIf
		Next

		; Populate $lvwPartitions
		For $i = 0 to UBound($asPartitions, 1) - 1
			$sPartName = ""
			$sDriveFreeSpace = ""
			If $asPartitions[$i][5] <> "" Then
				$sPartName = $asPartitions[$i][6] & ' (' & $asPartitions[$i][5] & ":)"
				If DriveStatus($asPartitions[$i][5] & ":") <> "UNKNOWN" Then	; check whether drive is formatted
					$sDriveFreeSpace = Int(DriveSpaceFree($asPartitions[$i][5] & ":")) & " MB"
				EndIf
			Else
				$sPartName = $asPartitions[$i][6]
			EndIf

			If $sPartName = "" Then $sPartName = " "	; Shows junk value in first listviewitem if empty

			GUICtrlCreateListViewItem($sPartName & '|' & $asPartitions[$i][1] & '|' & $asPartitions[$i][2] & _
									 '|' & $sDriveFreeSpace & '|' & $asPartitions[$i][7], $lvwPartitions)

			GUICtrlSendMsg($lvwPartitions, $LVM_SETCOLUMNWIDTH, 0, -1)
		Next
	EndIf

	frmDiskPart_ChangeControlState()
EndFunc

