#region - Alcohol.120.v2.0.1.2033 install script - (Automated with WinExists functions)

#include <IE.au3>
Opt('TrayIconDebug', 1)

; Installer.
$executable = 'ALCOHOLSETUP.EXE'
; Show progess.
$splash = 0
; Default catagory folder in startmenu.
$group = 'Alcohol 120%'
; New catagory to move the default folder into.
$catagory = ''
; Installation folder in Program Files.
$directory = 'Alcohol Soft\Alcohol 120'
; Allowed time for installation.
$allowed = 60 * 1000
; Components to choose. 1 = Yes, 0 = No.
$SecACID    = 1 ; A.C.I.D Wizard
$langfiles  = 1 ; Multi-Language Files   
$manual     = 0 ; Online manual
$shortcuts  = 1 ; Desktop Shortcut
$startmenu  = 1 ; Startmenu Entries
$starwind   = 0 ; iSCSI Service

; ----- Settings Complete (Paste registration on line 83) ------

; Set components to install via registry.
$key = 'HKLM\SOFTWARE\Alcohol Soft\Alcohol 120%\AddRemove\Components'
RegWrite($key & '\SecACID',         'Installed', 'Reg_Dword', $SecACID)
RegWrite($key & '\SecLangFiles',    'Installed', 'Reg_Dword', $langfiles)
RegWrite($key & '\SecManual',       'Installed', 'Reg_Dword', $manual)
RegWrite($key & '\SecShortcuts',    'Installed', 'Reg_Dword', $shortcuts)
RegWrite($key & '\SecStartMenu',    'Installed', 'Reg_Dword', $startmenu)
RegWrite($key & '\SecStarWind',     'Installed', 'Reg_Dword', $starwind)

; Run the installer.
$pid = _Install()
$time = TimerInit()
$title = 'Alcohol 120%'
Do
    Select
	    Case WinExists('Installer Language','Please select a language.')
            ControlClick('Installer Language','Please select a language.', 'Button1')
			
		;Case WinExists($title, 'Already Installed')
		;	_Abort()

		Case WinExists($title, '    Alcohol 120%')
            WinMove($title, '    Alcohol 120%', @DesktopWidth, 0)
            ControlClick($title, '    Alcohol 120%', 'Button2')

        Case WinExists($title, ' ')
            ControlClick($title, ' ', 'Button2')

        Case WinExists($title, '  ')
            ControlClick($title, '  ', 'Button2')

        Case WinExists($title, '  ')
            ControlClick($title, '  ', 'Button2')

        Case WinExists($title, '    Alcohol 52%')
            ControlCommand($title, '    Alcohol 52%', 'Button4', 'UnCheck'); Run
			;ControlCommand($title, '    Alcohol 52%', 'Button5', 'UnCheck'); Add Drive
            ControlClick($title, '    Alcohol 52%', 'Button2')

        Case Else
            Sleep(250)
    EndSelect
    If TimerDiff($time) > $allowed Then _Abort()
Until Not ProcessExists($pid)

; *** Paste Registration on the next line ***


; Exit if $startmenu = 0 from above.
If Not $startmenu Then Exit

; Remove shortcuts.
If _MainShortcut('Alcohol 120%.lnk') Then
    FileDelete('Alcohol Command Launcher.lnk')
    FileDelete('Alcohol Manual.lnk')
;~  FileDelete('Uninstall Alcohol 120%.lnk')
;~  _Desktop('Alcohol 120%.lnk')
EndIf

#endregion

Exit

Func _Install($path = Default)
    ; Run the installer in Default Script directory.
    Dim $splash
    If $path = Default Then $path = @ScriptDir
    If StringRight($path, 1) <> '\' Then $path &= '\'
    If StringInStr($executable, '\') Then $path = ''
    If Not FileExists($path & $executable) Then Exit 1
    If $splash Then _Splash('Installing:' & StringTrimRight(StringReplace(@ScriptName, '_', ' '), 4))
    If StringRight($executable, 3) = 'msi' Then
        Return Run('"' & @SystemDir & '\msiexec.exe" /i "' & $path & $executable & '"')
    Else
        Return Run('"' & $path & $executable & '"')
    EndIf
EndFunc

Func _Abort()
    ; close process if exists then exit.
    Dim $pid
    If ProcessExists($pid) Then
        ProcessClose($pid)
        Exit 2
    Else
        Exit 3
    EndIf
EndFunc

Func _Desktop($shortcut)
    ; Delete a Desktop shortcut.
    If FileExists(@DesktopDir & '\' & $shortcut) Then
        Return FileDelete(@DesktopDir & '\' & $shortcut)
    ElseIf FileExists(@DesktopCommonDir & '\' & $shortcut) Then
        Return FileDelete(@DesktopCommonDir & '\' & $shortcut)
    EndIf
EndFunc

Func _MainShortcut($shortcut, $rename = '')
    ; Change working directory to correct StartMenu\Group directory.
    Dim $group, $catagory, $splash
    If $group = '' Then Return 0
    If FileExists(@ProgramsDir & '\' & $group) Then
        FileChangeDir(@ProgramsDir & '\' & $group)
    ElseIf FileExists(@ProgramsCommonDir & '\' & $group) Then
        FileChangeDir(@ProgramsCommonDir & '\' & $group)
    Else
        Return 0
    EndIf
    ; Wait for main shortcut.
    If $splash Then _Splash('Waiting for shortcuts')
    For $i = 1 To 20
        If FileExists($shortcut) Then ExitLoop
        Sleep(500)
    Next
    If $splash Then _Splash('Cleaning up:' & StringTrimRight(StringReplace(@ScriptName, '_', ' '), 4))
    ; If catagory not assigned anything, then return.
    If $catagory = '' Then Return 1
    ; Move the group folder into the catagory folder.
    If FileChangeDir('..') And DirCopy($group, $catagory & '\' & $group, 1) Then
        If DirRemove($group, 1) Then
            ; If optional rename parameter is used, then rename the group folder.
            If $rename <> '' And FileChangeDir($catagory) Then
                If DirCopy($group, $rename, 1) And DirRemove($group, 1) Then
                    Return FileChangeDir($rename)
                EndIf
            Else
                Return FileChangeDir($catagory & '\' & $group)
            EndIf
        EndIf
    EndIf
EndFunc

Func _QuickLaunch($shortcut)
    ; Delete a Quicklaunch shortcut.
    Local $subdirs = '\Microsoft\Internet Explorer\Quick Launch'
    If FileExists(@AppDataDir & $subdirs & '\' & $shortcut) Then
        Return FileDelete(@AppDataDir & $subdirs & '\' & $shortcut)
    ElseIf FileExists(@AppDataCommonDir & $subdirs & '\' & $shortcut) Then
        Return FileDelete(@AppDataCommonDir & $subdirs & '\' & $shortcut)
    EndIf
EndFunc

Func _Splash($text = '')
    ; Shows a small borderless splash message.
    Dim $splash
    If $splash Then
        If $text Then
            SplashTextOn('', $text, 500, 25, -1, 5, 1, '', 14)
        Else
            SplashOff()
        EndIf
    EndIf
EndFunc

Func _WinClose($title, $text = '')
    ; Close a window with further attempts.
    For $i = 1 To 10
        WinClose($title, $text)
        If Not WinExists($title) Then Return 1
        Sleep(500)
    Next
EndFunc

Func OnAutoItStart()
    ; A 2nd script instance will exit.
    Local $interpreter
    $interpreter = StringTrimRight(@ScriptName, 4) & ' Script Interpreter'
    If WinExists($interpreter) Then Exit
    AutoItWinSetTitle($interpreter)
EndFunc
