#define MyAppName "WinDjView 1.0.3"
#define MyAppVersion "1.0.3"
#define MyAppExeName "WinDjView.exe"

[Setup]
AppId={{60F3D1CB-B2A7-46E7-92B0-93526131061D}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
AppVerName=WinDjView 1.0.3
;AppVerName={#MyAppName} {#MyAppVersion}
DefaultDirName={pf}\WinDjView
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=yes
InfoBeforeFile=C:\Users\Admin\Desktop\ss.rtf
OutputDir=D:\
OutputBaseFilename=WinDjView.v1.0.3
SetupIconFile=C:\Users\Admin\Desktop\win.ico
Compression=lzma
SolidCompression=yes
WizardImageFile=.bmp
WizardSmallImageFile=55x55.bmp
UninstallFilesDir={app}\uninstall
DirExistsWarning=no
DisablewelcomePage=yes


[Languages]
Name: "russian"; MessagesFile: "compiler:Languages\Russian.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Components]
Name: norm; Description: ; Flags: exclusive
Name: port; Description: ; Flags: exclusive

[Files]
Source: "WinDjViewPortable"; DestDir: {app}\port; Flags: ignoreversion createallsubdirs recursesubdirs sortfilesbyextension sortfilesbyname uninsneveruninstall; Components: port
Source: "C:\Program Files\WinDjView\*"; DestDir: {app}\norm; Flags: ignoreversion createallsubdirs recursesubdirs sortfilesbyextension sortfilesbyname; Components: norm 

[UninstallDelete]
Type: files; Name: {app}\ ; Components: port

[Icons] 
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon

[Code]
procedure CurStepChanged(CurStep: TSetupStep);
var
  AppPath: string;
  ResultCode: Integer;
begin
  AppPath := RemoveQuotes(ExpandConstant('{reg:HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{#SetupSetting("AppID")}_is1,InstallLocation|}'));
  if (CurStep = ssDone) and (IsComponentSelected('port')) then Exec(AppPath + '\uninstall\unins000.exe', '/VERYSILENT', '', SW_SHOW, ewNoWait, ResultCode);
end;

[Run]
Filename: "{app}\{#MyAppExeName}"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"; Flags: nowait postinstall skipifsilent

